/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.io;

import java.io.File;

/**
 * Possible file extensions
 * 
 */
public enum ExtensionType {
	TRA, XML, DTMC, CONF, NONE, LAB;

	/**
	 * return extension of filename, i.e. all symbols after the last '.' of
	 * filename
	 * 
	 * @param file
	 * @return Extension as enum
	 */
	public static ExtensionType getFileExtension(File file) {
		if (file != null) {
			int dotPos = file.getName().lastIndexOf(".");
			String extension = file.getName().substring(dotPos + 1);
			if (extension.equals("tra"))
				return ExtensionType.TRA;
			else if (extension.equals("xml"))
				return ExtensionType.XML;
			else if (extension.equals("dtmc"))
				return ExtensionType.DTMC;
			// else if (extension.equals("pm"))
			// return ExtensionType.PM;
			else if (extension.equals("conf"))
				return ExtensionType.CONF;
			else if (extension.equals("lab"))
				return ExtensionType.LAB;
			else
				return ExtensionType.NONE;
		} else {
			return ExtensionType.NONE;
		}
	}

	public String toString() {
		switch (this) {
		case TRA:
			return "tra";
		case XML:
			return "xml";
		case DTMC:
			return "dtmc";
			// case PM:
			// return "pm";
		case CONF:
			return "conf";
		case LAB:
			return "lab";
		case NONE: // fall through!
		default:
			return "";
		}
	}
}