/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.io.input;

import java.io.*;

import java.util.ArrayList;

import java.util.regex.*;

import comics.io.FileHandler;
import comics.utilities.Output;
import comics.utilities.Pair;

public class LabReader extends InputParser {

	public int count = 0;
	String fileContent = null;
	public ArrayList<String> declarationList;
	public ArrayList<Pair<Integer, String>> nodeList;

	public LabReader(File fileToReadFrom) {
		super(fileToReadFrom);
		declarationList = new ArrayList<String>();
		nodeList = new ArrayList<Pair<Integer, String>>();
	}

	public LabReader(String fileContent) {
		super(null);
		this.fileContent = fileContent;
	}

	@Override
	public boolean parse() {
		Matcher mat2 = null;
		Matcher mat3 = null;
		int nodeId = 0;
		int ergebnis[] = new int[10];

		for (int i = 0; i < ergebnis.length; i++) {
			ergebnis[i] = 0;
		}
		if (fileToReadFrom != null) {
			fileContent = FileHandler.fileContentToString(fileToReadFrom);
		}
		if (fileContent != null) {
			try {
				String[] lines = fileContent.split("\\r?" + Output.getLineBreak());
				for (String line : lines) {
					if (line == lines[1]) {
						Pattern pat2 = Pattern.compile("(\\w+)");
						mat2 = pat2.matcher(line);

						while (mat2.find()) {
							declarationList.add(mat2.group());
						}
					}
					if (line != lines[0] && line != lines[1] && line != lines[2]) {
						Pattern pat3 = Pattern.compile("(\\w+)");
						mat3 = pat3.matcher(line);
						mat3.find();
						try {
							nodeId = Integer.parseInt(mat3.group());
						} catch (NumberFormatException nfe) {
						}

						while (mat3.find()) {
							nodeList.add(new Pair<Integer, String>(nodeId, mat3.group()));
						}
					}
				}
			} catch (Exception ausnahme) {
				return false;
			}
		}
		return false;
	}
}