/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.io.input;

import java.io.*;

import java.util.ArrayList;

import java.util.TreeSet;

import java.util.regex.*;

import comics.graph.data.MarkovChain;
import comics.graph.data.Node;
import comics.io.FileHandler;
import comics.utilities.Output;

public class MrmcReader extends InputParser {

	public int count = 0;
	String fileContent = null;
	public ArrayList<String> declarationList;
	public ArrayList<String> nodeList;
	MarkovChain markovChain = new MarkovChain();
	Object[] objects;
	Node node;
	String s;
	public TreeSet<Node> nodeSet;
	boolean stringMode = false;
	boolean error;

	public MrmcReader(File fileToReadFrom, Object[] objects, MarkovChain mc) {
		super(fileToReadFrom);
		this.objects = objects;
		this.markovChain = mc;
		nodeSet = new TreeSet<Node>();
		declarationList = new ArrayList<String>();
		nodeList = new ArrayList<String>();
		error = false;
	}

	public MrmcReader(File fileToReadFrom, String s, MarkovChain mc) {
		super(fileToReadFrom);
		this.s = s;
		this.markovChain = mc;
		nodeSet = new TreeSet<Node>();
		declarationList = new ArrayList<String>();
		nodeList = new ArrayList<String>();
		stringMode = true;
		error = false;
	}

	public MrmcReader(String fileContent) {
		super(null);
		this.fileContent = fileContent;
	}

	@Override
	public boolean parse() {

		Matcher mat3 = null;
		int ergebnis[] = new int[10];

		for (int i = 0; i < ergebnis.length; i++)
			ergebnis[i] = 0;
		if (fileToReadFrom != null) {
			fileContent = FileHandler.fileContentToString(fileToReadFrom);
		}
		if (fileContent != null) {
			try {
				String[] lines = fileContent.split("\\r?" + Output.getLineBreak());
				for (String line : lines) {

					if (line != lines[0] && line != lines[1] && line != lines[2]) {
						Pattern pat3 = Pattern.compile("(\\w+)");
						mat3 = pat3.matcher(line);
						int myInt = 0;
						while (mat3.find()) {

							try {
								myInt = Integer.parseInt(mat3.group());

							} catch (NumberFormatException nfe) {

							}
							if (!stringMode) {
								for (int i = 0; i < objects.length; i++) {
									String mnm = String.valueOf(objects[i]);

									if (mat3.group().equals(mnm)) {

										if (myInt <= markovChain.getNodes().size()) {
											Node n = markovChain.getNodeByIntName(myInt);
											nodeSet.add(n);
										} else
											setError();
									}
								}
							} else {

								if (mat3.group().equals(s)) {
									if (myInt <= markovChain.getNodes().size()) {
										Node n = markovChain.getNodeByIntName(myInt);
										nodeSet.add(n);
									} else
										setError();

								}
							}
						}

					}

				}

			} catch (Exception ausnahme) {
				return false;
			}

		}

		return false;
	}

	public void setError() {
		error = true;
	}

	public boolean getError() {
		return error;
	}
}