/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

package comics.io.input;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

import comics.graph.data.MarkovChain;
import comics.tools.PrismParser;
import comics.utilities.Either;
import comics.utilities.Output;

public class PrismReader extends InputParser {

	public PrismReader(File fileToReadFrom) {
		super(fileToReadFrom);
	}

	@Override
	public boolean parse() {
		// Read complete file in StringBuffer
		FileReader reader = null;
		StringBuffer prismBuffer = new StringBuffer();
		try {
			reader = new FileReader(fileToReadFrom);
			for (int c; (c = reader.read()) != -1;)
				prismBuffer.append((char) c);
		} catch (IOException e) {
			System.err.println("Couldn't read file");
			return false;
		} finally {
			try {
				reader.close();
			} catch (Exception e) {
			}
		}

		// Parse prism file
		Either<ArrayList<String>, MarkovChain> resultEither = new PrismParser()
				.parseModel(prismBuffer.toString());
		if (resultEither.isLeft()) {
			// Errors happenend
			Output.print("Error loading prism");
			ArrayList<String> error = resultEither.getLeft();
			for (int i = 0; i < error.size(); i++) {
				Output.print(error.get(i));
			}
			return false;
		} else {
			// Loading was successfull
			Output.print("Markov chain successfully loaded from prism");
			result = resultEither.getRight();
			return true;
		}
	}

}
