/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.io.input;

import java.io.*;
import java.util.regex.*;

import comics.graph.data.MarkovChain;
import comics.io.FileHandler;
import comics.utilities.Output;

public class TraReader extends InputParser {

	public int count = 0;
	String fileContent = null;

	public TraReader(File fileToReadFrom) {
		super(fileToReadFrom);
	}

	public TraReader(String fileContent) {
		super(null);
		this.fileContent = fileContent;
	}

	@Override
	public boolean parse() {
		MarkovChain m = new MarkovChain();

		int ergebnis[] = new int[10];

		for (int i = 0; i < ergebnis.length; i++)
			ergebnis[i] = 0;
		if (fileToReadFrom != null) {
			fileContent = FileHandler.fileContentToString(fileToReadFrom);
		}
		if (fileContent != null) {
			try {
				String[] lines = fileContent.split("\\r?" + Output.getLineBreak());
				for (String line : lines) {
					Pattern pat1 = Pattern.compile("(STATES) (\\d+)");
					Matcher mat1 = pat1.matcher(line);

					Pattern pat5 = Pattern.compile("(\\d+) (\\d+) (\\b(\\d+)\\.(\\d+)\\b)");
					Matcher mat5 = pat5.matcher(line);

					Pattern pat6 = Pattern.compile("(\\d+) (\\d+) (1$)");
					Matcher mat6 = pat6.matcher(line);

					if (mat1.find()) {
						// Add all nodes 1 .. STATES
						int i = new Integer(mat1.group(2)).intValue();
						m.createAllNodesTil(i);

					}

					if (mat5.find()) {

						int i = new Integer(mat5.group(1)).intValue();
						int j = new Integer(mat5.group(2)).intValue();

						double k = Double.valueOf(mat5.group(3)).doubleValue();

						m.addEdge(m.getNodeByIntName(i), m.getNodeByIntName(j), k);
					}
					if (mat6.find()) {
						int i = new Integer(mat6.group(1)).intValue();
						int j = new Integer(mat6.group(2)).intValue();
						int k = new Integer(mat6.group(3)).intValue();

						m.addEdge(m.getNodeByIntName(i), m.getNodeByIntName(j), (double) k);

					}
				}
			} catch (Exception ausnahme) {
				return false;
			}
		} else {
			Output.print("No file and no string");
			return false;
		}

		result = m;
		return true;
	}
}
