/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.io.output;

import java.io.File;
import comics.graph.data.MarkovChain;
import comics.graph.data.Node;
import comics.utilities.Output;

public class LabWriter extends OutputFormatter {

	public LabWriter(MarkovChain chainToWrite, File fileToWriteTo) {
		super(chainToWrite, fileToWriteTo);
	}

	@Override
	protected String generateString(MarkovChain mc) {
		String lb = Output.getLineBreak();
		String s = "";
		s += "#DECLARATION" + lb;
		s += "INITIAL TARGET";
		for (String label : mc.getLabels()) {
			s += " " + label;
		}
		s += lb + "#END" + lb;

		String labels;
		for (Node node : mc.getNodes()) {
			labels = "";
			if (node.isInitial()) {
				labels += " INITIAL";
			}
			if (node.isTarget()) {
				labels += " TARGET";
			}
			for (String label : mc.getLabelsNode(node)) {
				labels += " " + label;
			}

			if (labels.length() > 0) {
				s += node.getNumber() + labels + lb;
			}
		}
		return s;
	}
}
