/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.tools.counterexample;

/**
 * Interface to the model checking / counter example generation library
 * 
 * Warning: If you rename this class or move it to another package, the JNI link
 * will break.
 */
public class JniMethods {

	private long peer;

	public JniMethods() {
		peer = create();
	}

	protected void destroy() {
		destroy(peer);
	}

	protected boolean loadFile(String filename) {
		return loadFile(peer, filename);
	}

	protected boolean loadData(String data) {
		return loadData(peer, data);
	}

	protected String modelCheck() {
		return modelCheck(peer);
	}

	protected double getResultProbability() {
		return getResultProbability(peer);
	}

	protected boolean initCounterExampleSearch(String xmlGraph, double probability, boolean abstractFlag, boolean globalFlag,
			boolean closureFlag) {
		return initCounterExampleSearch(peer, xmlGraph, probability, abstractFlag, globalFlag, closureFlag);
	}

	protected String doCounterExampleSteps(int[] concretizedNodes, boolean autoconcretize, boolean stepsTillEnd, int stepSize,
			int concretizeMode, int heuristic) {
		return doCounterExampleSteps(peer, concretizedNodes, autoconcretize, stepsTillEnd, stepSize, concretizeMode, heuristic);
	}

	protected boolean isCounterExampleComplete() {
		return isCounterExampleComplete(peer);
	}

	protected int getCounterExampleSteps() {
		return getCounterExampleSteps(peer);
	}

	protected double getCounterExampleProbability() {
		return getCounterExampleProbability(peer);
	}

	/** Native methods */

	private native long create();

	private native void destroy(long peer);

	private native boolean loadFile(long peer, String filename);

	private native boolean loadData(long peer, String data);

	private native String modelCheck(long peer);

	private native double getResultProbability(long peer);

	private native boolean initCounterExampleSearch(long peer, String xmlGraph, double probability, boolean abstractFlag,
			boolean globalFlag, boolean closureFlag);

	private native String doCounterExampleSteps(long peer, int[] concretizedNodes, boolean autoconcretize,
			boolean stepsTillEnd, int stepSize, int concretizeMode, int heuristic);

	private native boolean isCounterExampleComplete(long peer);

	private native int getCounterExampleSteps(long peer);

	private native double getCounterExampleProbability(long peer);

	static {
		if (System.getProperty("sun.arch.data.model").equals("64")) {
			System.loadLibrary("comics_jni_64");
		} else {
			System.loadLibrary("comics_jni_32");
		}
	}

}
