#!/bin/bash
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )/.." && pwd )"
SOURCES='src/GraphTypes.cpp
src/LocalLogging.cpp
src/Path.cpp
src/cex/AbstractStateSelector.cpp
src/cex/Closure.cpp
src/cex/CounterExampleParams.cpp
src/cex/CriticalSubSystem.cpp
src/cex/Statistics.cpp
src/cex/extrack/AbstractExtensionTracker.cpp
src/cex/extrack/ContentExtensionTracker.cpp
src/cex/extrack/PointerExtensionTracker.cpp
src/cex/gens/CexGenerator.cpp
src/cex/gens/AbstractCexGen.cpp
src/cex/gens/ConcreteCexGen.cpp
src/cex/pathfinder/PathFinder.cpp
src/cex/pathfinder/GlobalPathFinder.cpp
src/cex/pathfinder/LocalPathFinder.cpp
src/io/Configuration.cpp
src/io/IOWrapper.cpp
src/io/pugixml/pugixml.cpp
src/mc/SCC_MC.cpp
src/JavaInterface.cpp'


echo "Running autoreconf..."
cd $DIR/cmdl_src
autoreconf --install
if [ -e configure ]	
	then 		
		echo "Running configure script..."
		./configure --disable-debug
		if [ -e Makefile ]
			then
				echo "Building project..."
				make
        cd $DIR/scripts				
				./create_jni_libs.sh $1
        ./build_gui.sh
			else 
				echo -e "\e[00;31mNo Makefile was generated.\e[00m"								
		fi
	else 
		echo -e "\e[00;31mNo configure-script was generated.\e[00m"		
fi
