#!/bin/bash
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )/.." && pwd )"
echo "Building GUI"
echo "Compiling java sources..."
cd $DIR/gui_src
mkdir -p bin
javac -d bin/ -classpath lib/jgraphx.jar:lib/prismparser.jar:lib/l2fprod-common-all.jar:lib/scala-library.jar:src src/comics/Main.java 
cp -r src/resources bin
echo "Compiling successful!"
echo "Building jar file..."
cd bin
jar -cmf $DIR/gui_src/manifest.mf $DIR/gui_src/lib/comics.jar comics/ resources/
echo "Building successful!"
