#!/bin/bash 
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )/.." && pwd )"

SOURCES='cmdl_src/src/GraphTypes.cpp
cmdl_src/src/LocalLogging.cpp
cmdl_src/src/Path.cpp
cmdl_src/src/cex/AbstractStateSelector.cpp
cmdl_src/src/cex/Closure.cpp
cmdl_src/src/cex/CounterExampleParams.cpp
cmdl_src/src/cex/CriticalSubSystem.cpp
cmdl_src/src/cex/Statistics.cpp
cmdl_src/src/cex/extrack/AbstractExtensionTracker.cpp
cmdl_src/src/cex/extrack/ContentExtensionTracker.cpp
cmdl_src/src/cex/extrack/PointerExtensionTracker.cpp
cmdl_src/src/cex/gens/CexGenerator.cpp
cmdl_src/src/cex/gens/AbstractCexGen.cpp
cmdl_src/src/cex/gens/ConcreteCexGen.cpp
cmdl_src/src/cex/pathfinder/PathFinder.cpp
cmdl_src/src/cex/pathfinder/GlobalPathFinder.cpp
cmdl_src/src/cex/pathfinder/LocalPathFinder.cpp
cmdl_src/src/io/Configuration.cpp
cmdl_src/src/io/IOWrapper.cpp
cmdl_src/src/io/pugixml/pugixml.cpp
cmdl_src/src/mc/SCC_MC.cpp
cmdl_src/src/JavaInterface.cpp'

cd $DIR
echo "Trying to generate JNI libraries..."
if [ -z "$JAVA_HOME" ]
    then JAVA_HOME=$1
fi
if [ -n "$JAVA_HOME" ]
    then
        g++ -fPIC -o comics_jni.so -shared -I$JAVA_HOME/include -I$JAVA_HOME/include/linux $SOURCES    
        if [ -e comics_jni.so ]
            then
                echo "JNI library succesfully generated..."
                cp comics_jni.so jni_lib/libcomics_jni_32.so
                cp comics_jni.so gui_src/lib/libcomics_jni_32.so
                cp comics_jni.so jni_lib/libcomics_jni_64.so
                cp comics_jni.so gui_src/lib/libcomics_jni_64.so
                rm comics_jni.so
            else echo -e "\e[00;31mError: No JNI library was generated...\e[00m"
        fi
    else echo -e "\e[00;31mNo JAVA directory specified, could not generate JNI libraries...\e[00m"
fi
