#!/bin/bash 
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )/.." && pwd )"

SOURCES='cmdl_src/src/GraphTypes.cpp
cmdl_src/src/LocalLogging.cpp
cmdl_src/src/Path.cpp
cmdl_src/src/cex/AbstractStateSelector.cpp
cmdl_src/src/cex/Closure.cpp
cmdl_src/src/cex/CounterExampleParams.cpp
cmdl_src/src/cex/CriticalSubSystem.cpp
cmdl_src/src/cex/Statistics.cpp
cmdl_src/src/cex/extrack/AbstractExtensionTracker.cpp
cmdl_src/src/cex/extrack/ContentExtensionTracker.cpp
cmdl_src/src/cex/extrack/PointerExtensionTracker.cpp
cmdl_src/src/cex/gens/CexGenerator.cpp
cmdl_src/src/cex/gens/AbstractCexGen.cpp
cmdl_src/src/cex/gens/ConcreteCexGen.cpp
cmdl_src/src/cex/pathfinder/PathFinder.cpp
cmdl_src/src/cex/pathfinder/GlobalPathFinder.cpp
cmdl_src/src/cex/pathfinder/LocalPathFinder.cpp
cmdl_src/src/io/Configuration.cpp
cmdl_src/src/io/IOWrapper.cpp
cmdl_src/src/io/pugixml/pugixml.cpp
cmdl_src/src/mc/SCC_MC.cpp
cmdl_src/src/JavaInterface.cpp'

cd $DIR
echo "Trying to generate JNI libraries..."
if [ -z "$JAVA_HOME" ]
    then JAVA_HOME=$1
fi
if [ -n "$JAVA_HOME" ]
    then
		echo $1
        g++ -m64 -o comics_jni.dll -static-libgcc -Wl,--add-stdcall-alias -static-libstdc++ -shared -I$JAVA_HOME/include -I$JAVA_HOME/include/win32 $SOURCES    
        if [ -e comics_jni.dll ]
            then
                echo "JNI library succesfully generated..."
				cp comics_jni.dll jni_lib/comics_jni_64.dll
                cp comics_jni.dll gui_src/lib/comics_jni_64.dll
                rm comics_jni.dll
            else echo -e "\e[00;31mError: No JNI library was generated...\e[00m"
        fi
    else echo -e "\e[00;31mNo JAVA directory specified, could not generate JNI libraries...\e[00m"
fi
