/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class mxOrganicLayout
extends mxGraphLayout {
    protected boolean isOptimizeEdgeDistance = true;
    protected boolean isOptimizeEdgeCrossing = true;
    protected boolean isOptimizeEdgeLength = true;
    protected boolean isOptimizeBorderLine = true;
    protected boolean isOptimizeNodeDistribution = true;
    protected double minMoveRadius = 2.0;
    protected double moveRadius;
    protected double initialMoveRadius = 0.0;
    protected double radiusScaleFactor = 0.75;
    protected double averageNodeArea = 40000.0;
    protected double fineTuningRadius = 40.0;
    protected int maxIterations = 1000;
    protected double edgeDistanceCostFactor = 3000.0;
    protected double edgeCrossingCostFactor = 6000.0;
    protected double nodeDistributionCostFactor = 30000.0;
    protected double borderLineCostFactor = 5.0;
    protected double edgeLengthCostFactor = 0.02;
    protected double boundsX = 0.0;
    protected double boundsY = 0.0;
    protected double boundsWidth = 0.0;
    protected double boundsHeight = 0.0;
    protected int iteration;
    protected int triesPerCell = 8;
    protected double minDistanceLimit = 2.0;
    protected double minDistanceLimitSquared;
    protected double maxDistanceLimit = 100.0;
    protected double maxDistanceLimitSquared;
    protected int unchangedEnergyRoundCount;
    protected int unchangedEnergyRoundTermination = 5;
    protected boolean approxNodeDimensions = true;
    protected CellWrapper[] v;
    protected CellWrapper[] e;
    protected double[] xNormTry;
    protected double[] yNormTry;
    protected boolean isFineTuning = true;
    protected boolean disableEdgeStyle = true;
    protected boolean resetEdges = false;

    public mxOrganicLayout(mxGraph mxGraph2) {
        super(mxGraph2);
    }

    public mxOrganicLayout(mxGraph mxGraph2, Rectangle2D rectangle2D) {
        super(mxGraph2);
        this.boundsX = rectangle2D.getX();
        this.boundsY = rectangle2D.getY();
        this.boundsWidth = rectangle2D.getWidth();
        this.boundsHeight = rectangle2D.getHeight();
    }

    @Override
    public boolean isVertexIgnored(Object object) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Object object) {
        int n;
        int n2;
        double d;
        Object[] objectArray = this.graph.getChildVertices(object);
        Object[] objectArray2 = this.graph.getChildEdges(object);
        mxPoint mxPoint2 = null;
        mxRectangle mxRectangle2 = null;
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
        this.v = new CellWrapper[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.v[i] = new CellWrapper(objectArray[i]);
            hashtable.put(objectArray[i], new Integer(i));
            mxRectangle2 = this.getVertexBounds(objectArray[i]);
            if (mxPoint2 == null) {
                mxPoint2 = (mxRectangle)mxRectangle2.clone();
            } else {
                ((mxRectangle)mxPoint2).add(mxRectangle2);
            }
            double d2 = mxRectangle2.getWidth();
            double d3 = mxRectangle2.getHeight();
            this.v[i].x = mxRectangle2.getX() + d2 / 2.0;
            this.v[i].y = mxRectangle2.getY() + d3 / 2.0;
            if (this.approxNodeDimensions) {
                this.v[i].radiusSquared = Math.min(d2, d3);
                this.v[i].radiusSquared *= this.v[i].radiusSquared;
                continue;
            }
            this.v[i].radiusSquared = d2 * d2;
            this.v[i].heightSquared = d3 * d3;
        }
        if (this.averageNodeArea == 0.0) {
            if (this.boundsWidth == 0.0 && mxPoint2 != null) {
                this.boundsX = mxPoint2.getX();
                this.boundsY = mxPoint2.getY();
                this.boundsWidth = ((mxRectangle)mxPoint2).getWidth();
                this.boundsHeight = ((mxRectangle)mxPoint2).getHeight();
            }
        } else {
            double d4;
            double d5;
            double d6 = this.averageNodeArea * (double)objectArray.length;
            d = Math.sqrt(d6);
            if (mxRectangle2 != null) {
                d5 = mxPoint2.getX() + ((mxRectangle)mxPoint2).getWidth() / 2.0;
                d4 = mxPoint2.getY() + ((mxRectangle)mxPoint2).getHeight() / 2.0;
                this.boundsX = d5 - d / 2.0;
                this.boundsY = d4 - d / 2.0;
            } else {
                this.boundsX = 0.0;
                this.boundsY = 0.0;
            }
            this.boundsWidth = d;
            this.boundsHeight = d;
            if (this.boundsX < 0.0 || this.boundsY < 0.0) {
                d5 = Math.min(this.boundsX, this.boundsY);
                d4 = -d5;
                this.boundsX += d4;
                this.boundsY += d4;
            }
        }
        if (this.initialMoveRadius == 0.0) {
            this.initialMoveRadius = Math.max(this.boundsWidth, this.boundsHeight) / 2.0;
        }
        this.moveRadius = this.initialMoveRadius;
        this.minDistanceLimitSquared = this.minDistanceLimit * this.minDistanceLimit;
        this.maxDistanceLimitSquared = this.maxDistanceLimit * this.maxDistanceLimit;
        this.unchangedEnergyRoundCount = 0;
        this.e = new CellWrapper[objectArray2.length];
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        for (n2 = 0; n2 < this.e.length; ++n2) {
            this.e[n2] = new CellWrapper(objectArray2[n2]);
            Object object2 = mxIGraphModel2.getTerminal(objectArray2[n2], true);
            Object object3 = mxIGraphModel2.getTerminal(objectArray2[n2], false);
            Integer n3 = null;
            Integer n4 = null;
            if (object2 != null) {
                n3 = (Integer)hashtable.get(object2);
            }
            if (object3 != null) {
                n4 = (Integer)hashtable.get(object3);
            }
            this.e[n2].source = n3 != null ? n3 : -1;
            this.e[n2].target = n4 != null ? n4 : -1;
        }
        for (n2 = 0; n2 < this.v.length; ++n2) {
            this.v[n2].relevantEdges = this.getRelevantEdges(n2);
            this.v[n2].connectedEdges = this.getConnectedEdges(n2);
        }
        this.xNormTry = new double[this.triesPerCell];
        this.yNormTry = new double[this.triesPerCell];
        for (n2 = 0; n2 < this.triesPerCell; ++n2) {
            d = (double)n2 * (Math.PI * 2 / (double)this.triesPerCell);
            this.xNormTry[n2] = Math.cos(d);
            this.yNormTry[n2] = Math.sin(d);
        }
        n2 = mxIGraphModel2.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            Object object4 = mxIGraphModel2.getChildAt(object, i);
            if (this.isEdgeIgnored(object4)) continue;
            if (this.isResetEdges()) {
                this.graph.resetEdge(object4);
            }
            if (!this.isDisableEdgeStyle()) continue;
            this.setEdgeStyleEnabled(object4, false);
        }
        this.iteration = 0;
        while (this.iteration < this.maxIterations) {
            this.performRound();
            ++this.iteration;
        }
        double[][] dArray = new double[this.v.length][2];
        for (n = 0; n < this.v.length; ++n) {
            objectArray[n] = this.v[n].cell;
            mxRectangle2 = this.graph.getCellBounds(objectArray[n]);
            dArray[n][0] = this.v[n].x - mxRectangle2.getWidth() / 2.0;
            dArray[n][1] = this.v[n].y - mxRectangle2.getHeight() / 2.0;
        }
        mxIGraphModel2.beginUpdate();
        try {
            for (n = 0; n < objectArray.length; ++n) {
                this.setVertexLocation(objectArray[n], dArray[n][0], dArray[n][1]);
            }
        }
        finally {
            mxIGraphModel2.endUpdate();
        }
    }

    protected void performRound() {
        double d;
        boolean bl = false;
        block0: for (int i = 0; i < this.v.length; ++i) {
            int n = i;
            double d2 = this.getNodeDistribution(n);
            double d3 = this.getEdgeDistanceFromNode(n);
            d3 += this.getEdgeDistanceAffectedNodes(n);
            double d4 = this.getEdgeCrossingAffectedEdges(n);
            double d5 = this.getBorderline(n);
            double d6 = this.getEdgeLengthAffectedEdges(n);
            double d7 = this.getAdditionFactorsEnergy(n);
            for (int j = 0; j < this.triesPerCell; ++j) {
                double d8 = this.moveRadius * this.xNormTry[j];
                double d9 = this.moveRadius * this.yNormTry[j];
                double d10 = this.v[n].x;
                double d11 = this.v[n].y;
                this.v[n].x += d8;
                this.v[n].y += d9;
                double d12 = this.calcEnergyDelta(n, d2, d3, d4, d5, d6, d7);
                if (d12 < 0.0) {
                    bl = true;
                    continue block0;
                }
                this.v[n].x = d10;
                this.v[n].y = d11;
            }
        }
        if (bl) {
            this.unchangedEnergyRoundCount = 0;
        } else {
            ++this.unchangedEnergyRoundCount;
            this.moveRadius /= 2.0;
        }
        if (this.unchangedEnergyRoundCount >= this.unchangedEnergyRoundTermination) {
            this.iteration = this.maxIterations;
        }
        if (this.moveRadius - (d = this.moveRadius * this.radiusScaleFactor) < this.minMoveRadius) {
            d = this.moveRadius - this.minMoveRadius;
        }
        if (d <= this.minMoveRadius) {
            this.iteration = this.maxIterations;
        }
        if (d < this.fineTuningRadius) {
            this.isFineTuning = true;
        }
        this.moveRadius = d;
    }

    protected double calcEnergyDelta(int n, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        d7 += this.getNodeDistribution(n) * 2.0;
        d7 -= d * 2.0;
        d7 += this.getBorderline(n);
        d7 -= d4;
        d7 += this.getEdgeDistanceFromNode(n);
        d7 += this.getEdgeDistanceAffectedNodes(n);
        d7 -= d2;
        d7 -= d5;
        d7 += this.getEdgeLengthAffectedEdges(n);
        d7 -= d3;
        d7 += this.getEdgeCrossingAffectedEdges(n);
        d7 -= d6;
        return d7 += this.getAdditionFactorsEnergy(n);
    }

    protected double getNodeDistribution(int n) {
        double d;
        block6: {
            d = 0.0;
            if (!this.isOptimizeNodeDistribution) break block6;
            if (this.approxNodeDimensions) {
                for (int i = 0; i < this.v.length; ++i) {
                    if (n == i) continue;
                    double d2 = this.v[n].x - this.v[i].x;
                    double d3 = this.v[n].y - this.v[i].y;
                    double d4 = d2 * d2 + d3 * d3;
                    d4 -= this.v[n].radiusSquared;
                    if ((d4 -= this.v[i].radiusSquared) < this.minDistanceLimitSquared) {
                        d4 = this.minDistanceLimitSquared;
                    }
                    d += this.nodeDistributionCostFactor / d4;
                }
            } else {
                for (int i = 0; i < this.v.length; ++i) {
                    if (n == i) continue;
                    double d5 = this.v[n].x - this.v[i].x;
                    double d6 = this.v[n].y - this.v[i].y;
                    double d7 = d5 * d5 + d6 * d6;
                    d7 -= this.v[n].radiusSquared;
                    if ((d7 -= this.v[i].radiusSquared) < this.minDistanceLimitSquared) {
                        d7 = this.minDistanceLimitSquared;
                    }
                    d += this.nodeDistributionCostFactor / d7;
                }
            }
        }
        return d;
    }

    protected double getBorderline(int n) {
        double d = 0.0;
        if (this.isOptimizeBorderLine) {
            double d2;
            double d3;
            double d4;
            double d5 = this.v[n].x - this.boundsX;
            if (d5 < this.minDistanceLimit) {
                d5 = this.minDistanceLimit;
            }
            if ((d4 = this.v[n].y - this.boundsY) < this.minDistanceLimit) {
                d4 = this.minDistanceLimit;
            }
            if ((d3 = this.boundsX + this.boundsWidth - this.v[n].x) < this.minDistanceLimit) {
                d3 = this.minDistanceLimit;
            }
            if ((d2 = this.boundsY + this.boundsHeight - this.v[n].y) < this.minDistanceLimit) {
                d2 = this.minDistanceLimit;
            }
            d += this.borderLineCostFactor * (1000000.0 / (d4 * d4) + 1000000.0 / (d5 * d5) + 1000000.0 / (d2 * d2) + 1000000.0 / (d3 * d3));
        }
        return d;
    }

    protected double getEdgeLengthAffectedEdges(int n) {
        double d = 0.0;
        for (int i = 0; i < this.v[n].connectedEdges.length; ++i) {
            d += this.getEdgeLength(this.v[n].connectedEdges[i]);
        }
        return d;
    }

    protected double getEdgeLength(int n) {
        if (this.isOptimizeEdgeLength) {
            double d = Point2D.distance(this.v[this.e[n].source].x, this.v[this.e[n].source].y, this.v[this.e[n].target].x, this.v[this.e[n].target].y);
            return this.edgeLengthCostFactor * d * d;
        }
        return 0.0;
    }

    protected double getEdgeCrossingAffectedEdges(int n) {
        double d = 0.0;
        for (int i = 0; i < this.v[n].connectedEdges.length; ++i) {
            d += this.getEdgeCrossing(this.v[n].connectedEdges[i]);
        }
        return d;
    }

    protected double getEdgeCrossing(int n) {
        int n2 = 0;
        if (this.isOptimizeEdgeCrossing) {
            double d = this.v[this.e[n].source].x;
            double d2 = this.v[this.e[n].source].y;
            double d3 = this.v[this.e[n].target].x;
            double d4 = this.v[this.e[n].target].y;
            for (int i = 0; i < this.e.length; ++i) {
                boolean bl;
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                double d10;
                double d11;
                double d12;
                double d13 = this.v[this.e[i].source].x;
                double d14 = this.v[this.e[i].source].y;
                double d15 = this.v[this.e[i].target].x;
                double d16 = this.v[this.e[i].target].y;
                if (i == n) continue;
                if (d < d3) {
                    d12 = d;
                    d11 = d3;
                } else {
                    d12 = d3;
                    d11 = d;
                }
                if (d13 < d15) {
                    d10 = d13;
                    d9 = d15;
                } else {
                    d10 = d15;
                    d9 = d13;
                }
                if (d11 < d10 || d12 > d9) continue;
                if (d2 < d4) {
                    d8 = d2;
                    d7 = d4;
                } else {
                    d8 = d4;
                    d7 = d2;
                }
                if (d14 < d16) {
                    d6 = d14;
                    d5 = d16;
                } else {
                    d6 = d16;
                    d5 = d14;
                }
                if (d7 < d6 || d8 > d5 || d == d13 || d2 == d14 || d == d15 || d2 == d16 || d3 == d13 || d4 == d14 || d3 == d15 || d4 == d16) continue;
                boolean bl2 = bl = Line2D.relativeCCW(d, d2, d3, d4, d13, d14) != Line2D.relativeCCW(d, d2, d3, d4, d15, d16) && Line2D.relativeCCW(d13, d14, d15, d16, d, d2) != Line2D.relativeCCW(d13, d14, d15, d16, d3, d4);
                if (!bl) continue;
                ++n2;
            }
        }
        return this.edgeCrossingCostFactor * (double)n2;
    }

    protected double getEdgeDistanceFromNode(int n) {
        double d = 0.0;
        if (this.isOptimizeEdgeDistance && this.isFineTuning) {
            int[] nArray = this.v[n].relevantEdges;
            for (int i = 0; i < nArray.length; ++i) {
                double d2 = Line2D.ptSegDistSq(this.v[this.e[nArray[i]].source].x, this.v[this.e[nArray[i]].source].y, this.v[this.e[nArray[i]].target].x, this.v[this.e[nArray[i]].target].y, this.v[n].x, this.v[n].y);
                if ((d2 -= this.v[n].radiusSquared) < this.minDistanceLimitSquared) {
                    d2 = this.minDistanceLimitSquared;
                }
                if (!(d2 < this.maxDistanceLimitSquared)) continue;
                d += this.edgeDistanceCostFactor / d2;
            }
        }
        return d;
    }

    protected double getEdgeDistanceAffectedNodes(int n) {
        double d = 0.0;
        for (int i = 0; i < this.v[n].connectedEdges.length; ++i) {
            d += this.getEdgeDistanceFromEdge(this.v[n].connectedEdges[i]);
        }
        return d;
    }

    protected double getEdgeDistanceFromEdge(int n) {
        double d = 0.0;
        if (this.isOptimizeEdgeDistance && this.isFineTuning) {
            for (int i = 0; i < this.v.length; ++i) {
                if (this.e[n].source == i || this.e[n].target == i) continue;
                double d2 = Line2D.ptSegDistSq(this.v[this.e[n].source].x, this.v[this.e[n].source].y, this.v[this.e[n].target].x, this.v[this.e[n].target].y, this.v[i].x, this.v[i].y);
                if ((d2 -= this.v[i].radiusSquared) < this.minDistanceLimitSquared) {
                    d2 = this.minDistanceLimitSquared;
                }
                if (!(d2 < this.maxDistanceLimitSquared)) continue;
                d += this.edgeDistanceCostFactor / d2;
            }
        }
        return d;
    }

    protected double getAdditionFactorsEnergy(int n) {
        return 0.0;
    }

    protected int[] getRelevantEdges(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.e.length);
        for (int i = 0; i < this.e.length; ++i) {
            if (this.e[i].source == n || this.e[i].target == n) continue;
            arrayList.add(new Integer(i));
        }
        int[] nArray = new int[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        for (int i = 0; i < nArray.length; ++i) {
            if (!iterator.hasNext()) continue;
            nArray[i] = (Integer)iterator.next();
        }
        return nArray;
    }

    protected int[] getConnectedEdges(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.e.length);
        for (int i = 0; i < this.e.length; ++i) {
            if (this.e[i].source != n && this.e[i].target != n) continue;
            arrayList.add(new Integer(i));
        }
        int[] nArray = new int[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        for (int i = 0; i < nArray.length; ++i) {
            if (!iterator.hasNext()) continue;
            nArray[i] = (Integer)iterator.next();
        }
        return nArray;
    }

    public String toString() {
        return "Organic";
    }

    public double getAverageNodeArea() {
        return this.averageNodeArea;
    }

    public void setAverageNodeArea(double d) {
        this.averageNodeArea = d;
    }

    public double getBorderLineCostFactor() {
        return this.borderLineCostFactor;
    }

    public void setBorderLineCostFactor(double d) {
        this.borderLineCostFactor = d;
    }

    public double getEdgeCrossingCostFactor() {
        return this.edgeCrossingCostFactor;
    }

    public void setEdgeCrossingCostFactor(double d) {
        this.edgeCrossingCostFactor = d;
    }

    public double getEdgeDistanceCostFactor() {
        return this.edgeDistanceCostFactor;
    }

    public void setEdgeDistanceCostFactor(double d) {
        this.edgeDistanceCostFactor = d;
    }

    public double getEdgeLengthCostFactor() {
        return this.edgeLengthCostFactor;
    }

    public void setEdgeLengthCostFactor(double d) {
        this.edgeLengthCostFactor = d;
    }

    public double getFineTuningRadius() {
        return this.fineTuningRadius;
    }

    public void setFineTuningRadius(double d) {
        this.fineTuningRadius = d;
    }

    public double getInitialMoveRadius() {
        return this.initialMoveRadius;
    }

    public void setInitialMoveRadius(double d) {
        this.initialMoveRadius = d;
    }

    public boolean isFineTuning() {
        return this.isFineTuning;
    }

    public void setFineTuning(boolean bl) {
        this.isFineTuning = bl;
    }

    public boolean isOptimizeBorderLine() {
        return this.isOptimizeBorderLine;
    }

    public void setOptimizeBorderLine(boolean bl) {
        this.isOptimizeBorderLine = bl;
    }

    public boolean isOptimizeEdgeCrossing() {
        return this.isOptimizeEdgeCrossing;
    }

    public void setOptimizeEdgeCrossing(boolean bl) {
        this.isOptimizeEdgeCrossing = bl;
    }

    public boolean isOptimizeEdgeDistance() {
        return this.isOptimizeEdgeDistance;
    }

    public void setOptimizeEdgeDistance(boolean bl) {
        this.isOptimizeEdgeDistance = bl;
    }

    public boolean isOptimizeEdgeLength() {
        return this.isOptimizeEdgeLength;
    }

    public void setOptimizeEdgeLength(boolean bl) {
        this.isOptimizeEdgeLength = bl;
    }

    public boolean isOptimizeNodeDistribution() {
        return this.isOptimizeNodeDistribution;
    }

    public void setOptimizeNodeDistribution(boolean bl) {
        this.isOptimizeNodeDistribution = bl;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public double getMinDistanceLimit() {
        return this.minDistanceLimit;
    }

    public void setMinDistanceLimit(double d) {
        this.minDistanceLimit = d;
    }

    public double getMinMoveRadius() {
        return this.minMoveRadius;
    }

    public void setMinMoveRadius(double d) {
        this.minMoveRadius = d;
    }

    public double getNodeDistributionCostFactor() {
        return this.nodeDistributionCostFactor;
    }

    public void setNodeDistributionCostFactor(double d) {
        this.nodeDistributionCostFactor = d;
    }

    public double getRadiusScaleFactor() {
        return this.radiusScaleFactor;
    }

    public void setRadiusScaleFactor(double d) {
        this.radiusScaleFactor = d;
    }

    public int getTriesPerCell() {
        return this.triesPerCell;
    }

    public void setTriesPerCell(int n) {
        this.triesPerCell = n;
    }

    public int getUnchangedEnergyRoundTermination() {
        return this.unchangedEnergyRoundTermination;
    }

    public void setUnchangedEnergyRoundTermination(int n) {
        this.unchangedEnergyRoundTermination = n;
    }

    public double getMaxDistanceLimit() {
        return this.maxDistanceLimit;
    }

    public void setMaxDistanceLimit(double d) {
        this.maxDistanceLimit = d;
    }

    public boolean isApproxNodeDimensions() {
        return this.approxNodeDimensions;
    }

    public void setApproxNodeDimensions(boolean bl) {
        this.approxNodeDimensions = bl;
    }

    public boolean isDisableEdgeStyle() {
        return this.disableEdgeStyle;
    }

    public void setDisableEdgeStyle(boolean bl) {
        this.disableEdgeStyle = bl;
    }

    public boolean isResetEdges() {
        return this.resetEdges;
    }

    public void setResetEdges(boolean bl) {
        this.resetEdges = bl;
    }

    public class CellWrapper {
        protected Object cell;
        protected int[] relevantEdges = null;
        protected int[] connectedEdges = null;
        protected double x;
        protected double y;
        protected double radiusSquared;
        protected double heightSquared;
        protected int source;
        protected int target;

        public CellWrapper(Object object) {
            this.cell = object;
        }

        public int[] getRelevantEdges() {
            return this.relevantEdges;
        }

        public void setRelevantEdges(int[] nArray) {
            this.relevantEdges = nArray;
        }

        public int[] getConnectedEdges() {
            return this.connectedEdges;
        }

        public void setConnectedEdges(int[] nArray) {
            this.connectedEdges = nArray;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.x = d;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        public double getRadiusSquared() {
            return this.radiusSquared;
        }

        public void setRadiusSquared(double d) {
            this.radiusSquared = d;
        }

        public double getHeightSquared() {
            return this.heightSquared;
        }

        public void setHeightSquared(double d) {
            this.heightSquared = d;
        }

        public int getSource() {
            return this.source;
        }

        public void setSource(int n) {
            this.source = n;
        }

        public int getTarget() {
            return this.target;
        }

        public void setTarget(int n) {
            this.target = n;
        }

        public Object getCell() {
            return this.cell;
        }
    }
}

