/*
 * Decompiled with CFR 0.152.
 */
package comics.graph.data;

import com.mxgraph.model.mxCell;
import comics.graph.data.Labels;
import comics.graph.data.MarkovChain;
import comics.utilities.Output;
import java.io.Serializable;
import java.util.TreeSet;

public class Node
implements Comparable<Node>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int no;
    private double outgoingProbability;
    private boolean initial;
    private boolean target;
    private boolean reduced;
    private boolean hidden;
    private boolean inputOfScc;
    private boolean outputOfScc;
    private boolean positionSet = false;
    private double xpos = -1.0;
    private double ypos = -1.0;
    private TreeSet<Node> adjacentNodes = new TreeSet();
    private TreeSet<Node> adjacentToNodes = new TreeSet();
    private Labels labels = new Labels();
    private mxCell graphCell = null;
    private MarkovChain correspondingMarkovChain = null;

    protected Node(int n) {
        this.no = n;
        this.setInitial(false);
        this.setTarget(false);
        this.setReduced(false);
        this.setHidden(false);
        this.setInputOfScc(false);
        this.setOutputOfScc(false);
        this.setOutgoingProbability(0.0);
    }

    protected Node(String string) throws NumberFormatException {
        this(Integer.parseInt(string));
    }

    protected Node(int n, double d, double d2) {
        this(n);
        this.setPosition(d, d2);
    }

    public int getNumber() {
        return this.no;
    }

    public mxCell getGraphCell() {
        return this.graphCell;
    }

    public void setGraphCell(mxCell mxCell2) {
        this.graphCell = mxCell2;
    }

    public boolean isPositionSet() {
        return this.positionSet;
    }

    public double getXpos() {
        if (this.positionSet) {
            return this.xpos;
        }
        return -1.0;
    }

    public double getYpos() {
        if (this.positionSet) {
            return this.ypos;
        }
        return -1.0;
    }

    public void setPosition(double d, double d2) {
        this.xpos = d;
        this.ypos = d2;
        this.positionSet = true;
    }

    public double getOutgoingProbability() {
        return this.outgoingProbability;
    }

    protected void setOutgoingProbability(double d) {
        if (d > 1.0 || d < 0.0) {
            Output.print("Outgoing probability " + d + " for Node " + this.getNumber() + " is not valid.");
        } else {
            this.outgoingProbability = d;
        }
    }

    public boolean isInitial() {
        return this.initial;
    }

    protected void setInitial(boolean bl) {
        this.initial = bl;
        this.adjustStyle();
    }

    public boolean isTarget() {
        return this.target;
    }

    protected void setTarget(boolean bl) {
        this.target = bl;
        this.adjustStyle();
    }

    public boolean isReduced() {
        return this.reduced;
    }

    protected void setReduced(boolean bl) {
        this.reduced = bl;
        this.adjustStyle();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    protected Labels getLabels() {
        return this.labels;
    }

    protected void addLabel(String string) {
        this.labels.add(string);
    }

    public boolean isInputOfScc() {
        return this.inputOfScc;
    }

    protected void setInputOfScc(boolean bl) {
        this.inputOfScc = bl;
        this.adjustStyle();
    }

    public boolean isOutputOfScc() {
        return this.outputOfScc;
    }

    protected void setOutputOfScc(boolean bl) {
        this.outputOfScc = bl;
        this.adjustStyle();
    }

    public MarkovChain getCorrespondingMarkovChain() {
        return this.correspondingMarkovChain;
    }

    protected void setCorrespondingMarkovChain(MarkovChain markovChain) {
        this.correspondingMarkovChain = markovChain;
    }

    protected TreeSet<Node> getAdjacentNodes() {
        return this.adjacentNodes;
    }

    protected TreeSet<Node> getAdjacentToNodes() {
        return this.adjacentToNodes;
    }

    public boolean isAbsorbing() {
        if (this.getAdjacentNodes().size() == 0) {
            return true;
        }
        return this.getAdjacentNodes().size() == 1 && this.equals(this.getAdjacentNodes().first());
    }

    public boolean isConsistent() {
        if (this.getOutgoingProbability() < 1.0) {
            Output.print("WARNING: Outgoing probability of Node " + this.getNumber() + " is too low (by " + (1.0 - this.getOutgoingProbability()) + ")");
            return false;
        }
        if (this.getOutgoingProbability() > 1.0) {
            Output.print("WARNING: Outgoing probability of Node " + this.getNumber() + " is too high (by " + (this.getOutgoingProbability() - 1.0) + ")");
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Node node) {
        return Math.abs(this.getNumber()) - Math.abs(node.getNumber());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Node)) {
            return false;
        }
        return ((Node)object).getNumber() == this.getNumber();
    }

    public boolean hasAdjacentNodes() {
        if (!this.getAdjacentNodes().isEmpty()) {
            return true;
        }
        return !this.getAdjacentToNodes().isEmpty();
    }

    public void adjustStyle() {
        if (this.graphCell == null) {
            return;
        }
        String string = "DEFAULT_NODE";
        if (this.isReduced()) {
            string = "REDUCED_NODE";
        } else if (this.isInputOfScc()) {
            string = "SUBGRAPH_NODE";
        } else if (this.isTarget()) {
            string = this.isInitial() ? "INITIAL_TARGET_NODE" : "TARGET_NODE";
        } else if (this.isInitial()) {
            string = "INITIAL_NODE";
        }
        this.graphCell.setStyle(string);
    }

    public String propertyString() {
        String string = "";
        if (this.isInitial()) {
            string = string + "Initial";
        }
        if (this.isTarget()) {
            if (!string.isEmpty()) {
                string = string + ", ";
            }
            string = string + "Target";
        }
        if (this.isInputOfScc()) {
            if (!string.isEmpty()) {
                string = string + ", ";
            }
            string = string + "InputOfSCC";
        }
        if (this.reduced) {
            if (!string.isEmpty()) {
                string = string + ", ";
            }
            string = string + "Reduced";
        }
        if (!this.labels.isEmpty()) {
            if (!string.isEmpty()) {
                string = string + ", ";
            }
            string = string + "[";
            string = string + this.labels.toString();
            string = string + "]";
        }
        return string;
    }

    public String toString() {
        return "" + this.getNumber();
    }
}

