/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.actions;

import comics.gui.EditMode;
import comics.gui.GUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;

public class NodeColorAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_NODE = 0;
    public static final int INITIAL_NODE = 1;
    public static final int TARGET_NODE = 2;
    public static final int REDUCED_NODE = 3;
    private GUI gui;
    private int nodeType;

    public NodeColorAction(GUI gUI, int n) {
        this.gui = gUI;
        this.nodeType = n;
        switch (n) {
            case 1: {
                this.putValue("Name", "Initial state");
                break;
            }
            case 2: {
                this.putValue("Name", "Target states");
                break;
            }
            case 3: {
                this.putValue("Name", "Reduced states");
                break;
            }
            default: {
                this.putValue("Name", "Default states");
            }
        }
        this.putValue("SwingDisplayedMnemonicIndexKey", 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(GUI.getFrame(), "Choose a color", Color.red);
        switch (this.nodeType) {
            case 1: {
                this.gui.wrapper.setInitialNodeColor(color);
                break;
            }
            case 2: {
                this.gui.wrapper.setTargetNodeColor(color);
                break;
            }
            case 3: {
                this.gui.wrapper.setReducedNodeColor(color);
                break;
            }
            default: {
                this.gui.wrapper.setDefaultNodeColor(color);
            }
        }
        this.gui.wrapper.setEditMode(EditMode.NONE);
    }
}

