/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.counterexample;

import comics.data.CounterExampleSearchParameters;
import comics.gui.GUI;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class CounterExampleStepDialog
implements ActionListener {
    private ButtonGroup stepCountButtonGroup = new ButtonGroup();
    private JRadioButton noAutoConcretizeButton;
    private JRadioButton stepTillEndButton;
    private JRadioButton stepSizeButton;
    private JSpinner stepSpinner;
    private JComboBox heuristicComboBox;
    private JComboBox concretizationComboBox;
    private JPanel stepPanel = new JPanel();
    private JPanel stepSizePanel = new JPanel();
    private JPanel heuristicPanel = new JPanel();
    private JPanel concretizationPanel = new JPanel();

    public boolean show(CounterExampleSearchParameters counterExampleSearchParameters) {
        this.stepPanel.setLayout(new GridLayout(4, 1));
        JLabel jLabel = new JLabel("Concretization Mode");
        this.stepPanel.add(jLabel);
        this.stepTillEndButton = new JRadioButton("Search/concretize until concrete system results");
        this.stepTillEndButton.setActionCommand("stepsTillEnd");
        this.stepTillEndButton.addActionListener(this);
        this.stepCountButtonGroup.add(this.stepTillEndButton);
        this.stepPanel.add(this.stepTillEndButton);
        this.stepSizeButton = new JRadioButton("Choose number of search/concretization iterations");
        this.stepSizeButton.setActionCommand("userStepSize");
        this.stepSizeButton.addActionListener(this);
        this.stepCountButtonGroup.add(this.stepSizeButton);
        this.stepPanel.add(this.stepSizeButton);
        this.noAutoConcretizeButton = new JRadioButton("No automatic concretization");
        this.noAutoConcretizeButton.setActionCommand("noConcretize");
        this.noAutoConcretizeButton.addActionListener(this);
        this.stepCountButtonGroup.add(this.noAutoConcretizeButton);
        this.stepPanel.add(this.noAutoConcretizeButton);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(counterExampleSearchParameters.getStepSize(), 1, Integer.MAX_VALUE, 1);
        this.stepSpinner = new JSpinner(spinnerNumberModel);
        this.stepSizePanel.setLayout(new GridLayout(2, 1));
        JLabel jLabel2 = new JLabel("Number of automatic steps");
        this.stepSizePanel.add(jLabel2);
        this.stepSizePanel.add(this.stepSpinner);
        this.heuristicComboBox = new JComboBox<CounterExampleSearchParameters.Heuristic>(CounterExampleSearchParameters.Heuristic.values());
        this.heuristicComboBox.setSelectedItem((Object)counterExampleSearchParameters.getHeuristic());
        this.heuristicPanel.setLayout(new GridLayout(2, 1));
        JLabel jLabel3 = new JLabel("Heuristics for the choice of abstract node to concretize:");
        this.heuristicPanel.add(jLabel3);
        this.heuristicPanel.add(this.heuristicComboBox);
        this.concretizationComboBox = new JComboBox<CounterExampleSearchParameters.ConcretizationMode>(CounterExampleSearchParameters.ConcretizationMode.values());
        this.concretizationComboBox.setSelectedItem((Object)counterExampleSearchParameters.getConcretizationMode());
        this.concretizationPanel.setLayout(new GridLayout(2, 1));
        JLabel jLabel4 = new JLabel("Count of SCCs to concretize in each step");
        this.concretizationPanel.add(jLabel4);
        this.concretizationPanel.add(this.concretizationComboBox);
        this.initialize(counterExampleSearchParameters);
        Object[] objectArray = new Object[]{this.stepPanel, this.stepSizePanel, this.heuristicPanel, this.concretizationPanel};
        JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 2);
        JDialog jDialog = jOptionPane.createDialog(GUI.getFrame(), "Choose Parameters for Counterexample");
        jDialog.setVisible(true);
        if (jOptionPane.getValue() == null || !jOptionPane.getValue().equals(0)) {
            return false;
        }
        counterExampleSearchParameters.setNoAutoConcretize(this.noAutoConcretizeButton.isSelected());
        if (!counterExampleSearchParameters.isNoAutoConcretize()) {
            counterExampleSearchParameters.setStepsTillEnd(this.stepTillEndButton.isSelected());
            if (!counterExampleSearchParameters.isStepsTillEnd()) {
                counterExampleSearchParameters.setStepSize(spinnerNumberModel.getNumber().intValue());
            }
            counterExampleSearchParameters.setHeuristic((CounterExampleSearchParameters.Heuristic)((Object)this.heuristicComboBox.getSelectedItem()));
            counterExampleSearchParameters.setConcretizationMode((CounterExampleSearchParameters.ConcretizationMode)((Object)this.concretizationComboBox.getSelectedItem()));
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("noConcretize")) {
            this.setEnabledParameter(false);
            this.stepSpinner.setEnabled(false);
        } else if (actionEvent.getActionCommand().equals("stepsTillEnd")) {
            this.setEnabledParameter(true);
            this.stepSpinner.setEnabled(false);
        } else {
            this.setEnabledParameter(true);
            this.stepSpinner.setEnabled(true);
        }
    }

    private void initialize(CounterExampleSearchParameters counterExampleSearchParameters) {
        if (counterExampleSearchParameters.isNoAutoConcretize()) {
            this.noAutoConcretizeButton.setSelected(true);
            this.stepSpinner.setEnabled(false);
            this.setEnabledParameter(false);
        } else if (counterExampleSearchParameters.isStepsTillEnd()) {
            this.stepTillEndButton.setSelected(true);
            this.stepSpinner.setEnabled(false);
            this.setEnabledParameter(true);
        } else {
            this.stepSizeButton.setSelected(true);
            this.stepSpinner.setEnabled(true);
            this.setEnabledParameter(true);
        }
    }

    private void setEnabledParameter(boolean bl) {
        this.heuristicComboBox.setEnabled(bl);
        this.concretizationComboBox.setEnabled(bl);
    }
}

