/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.output_panel;

import comics.SCC_MC;
import comics.data.Config;
import comics.graph.data.Edge;
import comics.graph.data.MarkovChain;
import comics.graph.data.Node;
import comics.gui.output_panel.OverviewPanel;
import comics.gui.output_panel.TabEdges;
import comics.gui.output_panel.TabNodes;
import comics.gui.output_panel.TabTargetNodes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class OutputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private TabNodes tabNodes;
    private TabEdges tabEdges;
    private TabTargetNodes tabTargetNodes;
    private OverviewPanel overviewPanel;

    public OutputPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.overviewPanel = new OverviewPanel();
        this.tabNodes = new TabNodes(this.overviewPanel);
        this.tabEdges = new TabEdges(this.overviewPanel);
        this.tabTargetNodes = new TabTargetNodes(this.overviewPanel);
        this.tabbedPane.add(this.tabNodes);
        this.tabbedPane.add(this.tabEdges);
        this.tabbedPane.add(this.tabTargetNodes);
        this.add((Component)this.overviewPanel, "Last");
        this.overviewPanel.setPreferredSize(new Dimension(Config.overviewPanelWidth, Config.overviewPanelHeight));
    }

    public TabNodes getTabNodes() {
        return this.tabNodes;
    }

    public TabTargetNodes getTabTargetNodes() {
        return this.tabTargetNodes;
    }

    public TabEdges getTabEdges() {
        return this.tabEdges;
    }

    public OverviewPanel getOverviewPanel() {
        return this.overviewPanel;
    }

    public void clear() {
        this.tabNodes.clear();
        this.tabTargetNodes.clear();
        this.tabEdges.clear();
        this.overviewPanel.setDefault();
    }

    public void loadMarkovChain() {
        MarkovChain markovChain = SCC_MC.getInstance().getMarkovChain();
        if (markovChain != null) {
            this.tabNodes.clear();
            this.tabTargetNodes.clear();
            for (Node comparable : markovChain.getNodes()) {
                this.tabNodes.addNode(comparable);
                this.tabTargetNodes.addNode(comparable);
            }
            this.tabEdges.clear();
            for (Edge edge : markovChain.getEdges()) {
                this.tabEdges.addEdge(edge);
            }
        }
        this.overviewPanel.reloadValues();
    }
}

