/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef ABSTRACTPARAMETER_H_
#define ABSTRACTPARAMETER_H_

#include "Rational.h"

#include <vector>
#include <string>
#include <ginac/ginac.h>

using namespace GiNaC;

namespace parametric {

/**
 * Holds rational function for abstracted transitions and introduces new variable for this abstraction
 */
class AbstractParameter {
public:
	AbstractParameter(const Rational&);
	~AbstractParameter();

	friend std::ostream &operator<<(std::ostream&, const AbstractParameter&);

	std::string toPrefixNotation() const;

	static const exmap& getSubstitutions();

	inline const Rational& getParameterRational() const {
		return parameterRational;
	}

	inline const Rational& getValue() const {
		return value;
	}

private:
	symbol parameterSymbol;
	Rational parameterRational;
	Rational value;

	static exmap substitutions;
	static unsigned int count;
};
}
#endif
