/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef CANCELLATOR_H
#define CANCELLATOR_H

#include <string>
#include <ginac/ginac.h>
#include "Rational.h"
#include "../typedefs.h"
#include "boost/tuple/tuple.hpp"

using namespace GiNaC;
using namespace std;
using namespace boost;

namespace parametric {

/**
 * Data structure for result of gcd computation
 */
class GCDResult {
public:
	GCDResult(constPoly, constPoly, constPoly);
	GCDResult(const GCDResult&);
	~GCDResult();

	friend std::ostream &operator<<(std::ostream&, const GCDResult&);

	constPoly gcd;
	constPoly rest1;
	constPoly rest2;
};

/**
 * Singleton with Operations for cancellation and simplification of rational functions by use of computed factorization and GiNaC
 */
class Cancellator {
public:
	static Cancellator& getInstance();

	clock_t getCancelTime() {
		return cancelTime;
	}

	clock_t getAdditionTime() {
		return additionTime;
	}

	clock_t getCommonCoefficientTime() {
		return commonCoefficientTime;
	}

	void cancel(Rational&, bool);
	Rational additionFactorization(const Rational&, const Rational&);
private:
	Cancellator();
	Cancellator(const Cancellator&);
	virtual ~Cancellator();

	GCDResult computeGCD(constPoly, constPoly, bool);
	GCDResult gcdFactorization(constPoly, constPoly, bool);
	GCDResult gcdGinac(constPoly, constPoly);
	numeric getCommonCoefficient(constPoly);
	numeric getCommonCoefficient(const ex&);

	GCDPairSet gcdPairSet;

	clock_t cancelTime;
	clock_t additionTime;
	clock_t commonCoefficientTime;
};
}
#endif
