/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef CONSTRAINT_H_
#define CONSTRAINT_H_
#include "Rational.h"
#include "../typedefs.h"

namespace parametric {

/**
 * Holds constraint as two rational functions and one operator
 */
class Constraint {
	friend class ParametricSets;
	friend class constraintEqual;
	friend class constraintHash;
public:
	Constraint(const Rational& rat1, const Rational& rat2, OperatorType opType) :
			rational1(rat1), rational2(rat2), operatorType(opType) {
	}
	~Constraint() {
	}
	friend std::ostream &operator<<(std::ostream&, const Constraint&);
	std::string toPrefixNotation() const;
	std::string toXMLString() const;

private:
	Rational rational1;
	Rational rational2;
	OperatorType operatorType;
};

}
#endif /* CONSTRAINT_H_ */
