/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef FACTORIZATION_H
#define FACTORIZATION_H

#include "ParametricSets.h"
#include <boost/unordered_map.hpp>
#include <boost/optional.hpp>

using namespace GiNaC;
using namespace std;
using namespace boost;

namespace parametric {

/**
 * Data structure for factor
 */
class Factor {
public:
	Factor(constPoly, unsigned int);
	~Factor();

	friend std::ostream &operator<<(std::ostream&, const Factor&);

	string toString() const;

	constPoly pol;
	unsigned int exponent;
};

typedef boost::unordered_map<const Polynomial*, unsigned int, polynomialHash, polynomialEqual> FactorMap;
typedef FactorMap::const_iterator factors_const_it;
typedef FactorMap::iterator factors_it;
typedef list<Factor> FactorList;
typedef FactorList::iterator factorList_it;
typedef FactorList::const_iterator factorList_const_it;

/**
 * Data structure for factorization
 */
class Factorization {
public:
	Factorization(constPoly);
	~Factorization();

	friend std::ostream &operator<<(std::ostream&, const Factorization&);

	void setFactors(constPoly, constPoly);
	void setFactorPower(constPoly, unsigned int);
	void setFactorization(const ex&);
	void setFactorization(const FactorList&);
	FactorMap getFactors(bool refine = true);
	static const ex getExpressionFromFactorization(const FactorList&);

	inline bool isEmpty() const {
		return factorization.empty();
	}

	bool checkFactorization() const;

private:
	void insertFactor(constPoly, unsigned int = 1);
	void clearFactorization();
	void refineFactorization();

	const Polynomial* originalPol;
	FactorMap factorization;
};
}
#endif
