/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef TRIBOOL_H
#define TRIBOOL_H

#include <boost/logic/tribool.hpp>

using namespace boost;

namespace param_sccmc {

//Extends bool for third undefined case
enum class TRIBOOL {
	TRUE, FALSE, UNDEF
};

class TriBool {
public:
	static bool toBoolUndefFalse(bool val) {
		return val;
	}

	static bool toBoolUndefFalse(TRIBOOL val) {
		if (val == TRIBOOL::TRUE) {
			return true;
		} else if (val == TRIBOOL::FALSE) {
			return false;
		} else {
			//Undef => return false
			return false;
		}
	}

	static bool toBoolUndefTrue(bool val) {
		return val;
	}

	static bool toBoolUndefTrue(TRIBOOL val) {
		if (val == TRIBOOL::TRUE) {
			return true;
		} else if (val == TRIBOOL::FALSE) {
			return false;
		} else {
			//Undef => return true
			return true;
		}
	}
};

}

#endif
