/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#include <limits.h>
#include "Configuration.h"

namespace scc_cex {

bool ConfigurationSingleton::isIoflBenchmarkConc() const {
	return iofl_benchmark_conc;
}

bool ConfigurationSingleton::isIoflBenchmarkHeuristic() const {
	return iofl_benchmark_heuristic;
}

bool ConfigurationSingleton::isIoflBenchmarkSelection() const {
	return iofl_benchmark_selection;
}

bool ConfigurationSingleton::isIoflBenchmarkSearch() const {
	return iofl_benchmark_search;
}

bool ConfigurationSingleton::isIoflBoundPathsum() const {
	return iofl_bound_pathsum;
}

bool ConfigurationSingleton::isIoflCexConcrete() const {
	return iofl_cex_concrete;
}

bool ConfigurationSingleton::isIoflCexLocal() const {
	return iofl_cex_local;
}

bool ConfigurationSingleton::isIoflChooseDegree() const {
	return iofl_choose_degree;
}

bool ConfigurationSingleton::isIoflChooseMembership() const {
	return iofl_choose_membership;
}

bool ConfigurationSingleton::isIoflChooseProbability() const {
	return iofl_choose_probability;
}

bool ConfigurationSingleton::isIoflExternalCaller() const {
	return iofl_external_caller;
}

bool ConfigurationSingleton::isIoflForceAbstract() const {
	return iofl_force_abstract;
}

bool ConfigurationSingleton::isIoflForceClosure() const {
	return iofl_force_closure;
}

bool ConfigurationSingleton::isIoflForceGlobal() const {
	return iofl_force_global;
}

bool ConfigurationSingleton::isIoflForceProbBound() const {
	return iofl_force_probBound;
}

bool ConfigurationSingleton::isIoflInputIsData() const {
	return iofl_input_is_data;
}

bool ConfigurationSingleton::isIoflIncreasingElimOrder() const {
	return iofl_increasing_elim_order;
}

bool ConfigurationSingleton::isIoflInputIsFile() const {
	return iofl_input_is_file;
}

bool ConfigurationSingleton::isIoflLog() const {
	return iofl_log;
}

bool ConfigurationSingleton::isIoflNoConfig() const {
	return iofl_no_config;
}

bool ConfigurationSingleton::isIoflNoModelChecking() const {
	return iofl_no_ModelChecking;
}

bool ConfigurationSingleton::isIoflOnlyModelChecking() const {
	return iofl_only_ModelChecking;
}

bool ConfigurationSingleton::isIoflOutputAsDtmc() const {
	return iofl_output_as_dtmc;
}

bool ConfigurationSingleton::isIoflOutputAsXml() const {
	return iofl_output_as_xml;
}

bool ConfigurationSingleton::isIoflReadFromXml() const {
	return iofl_read_from_xml;
}

bool ConfigurationSingleton::isIoflSaveIterations() const {
	return iofl_save_iterations;
}

bool ConfigurationSingleton::isIoflStateElim() const {
	return iofl_state_elim;
}

bool ConfigurationSingleton::isIoflWaitForCalls() const {
	return iofl_wait_for_calls;
}

EliminationOrder::ORDER ConfigurationSingleton::getIoflElimOrder() const {
	return iofl_elim_order;
}

void ConfigurationSingleton::setIoflBenchmarkConc(bool ioflBenchmarkConc) {
	iofl_benchmark_conc = ioflBenchmarkConc;
}

void ConfigurationSingleton::setIoflBenchmarkHeuristic(bool ioflBenchmarkHeuristic) {
	iofl_benchmark_heuristic = ioflBenchmarkHeuristic;
}

void ConfigurationSingleton::setIoflBenchmarkSelection(bool ioflBenchmarkSelection) {
	iofl_benchmark_selection = ioflBenchmarkSelection;
}

void ConfigurationSingleton::setIoflBenchmarkSearch(bool ioflBenchmarkSearch) {
	iofl_benchmark_search = ioflBenchmarkSearch;
}

void ConfigurationSingleton::setIoflBoundPathsum(bool ioflBoundPathsum) {
	iofl_bound_pathsum = ioflBoundPathsum;
}

void ConfigurationSingleton::setIoflCexConcrete(bool ioflCexConcrete) {
	iofl_cex_concrete = ioflCexConcrete;
}

void ConfigurationSingleton::setIoflCexLocal(bool ioflCexLocal) {
	iofl_cex_local = ioflCexLocal;
}

void ConfigurationSingleton::setIoflChooseDegree(bool ioflChooseDegree) {
	iofl_choose_degree = ioflChooseDegree;
}

void ConfigurationSingleton::setIoflChooseMembership(bool ioflChooseMembership) {
	iofl_choose_membership = ioflChooseMembership;
}

void ConfigurationSingleton::setIoflChooseProbability(bool ioflChooseProbability) {
	iofl_choose_probability = ioflChooseProbability;
}

void ConfigurationSingleton::setIoflExternalCaller(bool ioflExternalCaller) {
	iofl_external_caller = ioflExternalCaller;
}

void ConfigurationSingleton::setIoflForceAbstract(bool ioflForceAbstract) {
	iofl_force_abstract = ioflForceAbstract;
}

void ConfigurationSingleton::setIoflForceClosure(bool ioflForceClosure) {
	iofl_force_closure = ioflForceClosure;
}

void ConfigurationSingleton::setIoflForceGlobal(bool ioflForceGlobal) {
	iofl_force_global = ioflForceGlobal;
}

void ConfigurationSingleton::setIoflForceProbBound(bool ioflForceProbBound) {
	iofl_force_probBound = ioflForceProbBound;
}

void ConfigurationSingleton::setIoflIncreasingElimOrder(bool ioflIncreasingElimOrder) {
	iofl_increasing_elim_order = ioflIncreasingElimOrder;
}

void ConfigurationSingleton::setIoflInputIsData(bool ioflInputIsData) {
	iofl_input_is_data = ioflInputIsData;
}

void ConfigurationSingleton::setIoflInputIsFile(bool ioflInputIsFile) {
	iofl_input_is_file = ioflInputIsFile;
}

void ConfigurationSingleton::setIoflLog(bool ioflLog) {
	iofl_log = ioflLog;
}

void ConfigurationSingleton::setIoflNoConfig(bool ioflNoConfig) {
	iofl_no_config = ioflNoConfig;
}

void ConfigurationSingleton::setIoflNoModelChecking(bool ioflNoModelChecking) {
	iofl_no_ModelChecking = ioflNoModelChecking;
}

void ConfigurationSingleton::setIoflOnlyModelChecking(bool ioflOnlyModelChecking) {
	iofl_only_ModelChecking = ioflOnlyModelChecking;
}

void ConfigurationSingleton::setIoflOutputAsDtmc(bool ioflOutputAsDtmc) {
	iofl_output_as_dtmc = ioflOutputAsDtmc;
}

void ConfigurationSingleton::setIoflOutputAsXml(bool ioflOutputAsXml) {
	iofl_output_as_xml = ioflOutputAsXml;
}

void ConfigurationSingleton::setIoflReadFromXml(bool ioflReadFromXml) {
	iofl_read_from_xml = ioflReadFromXml;
}

void ConfigurationSingleton::setIoflSaveIterations(bool ioflSaveIterations) {
	iofl_save_iterations = ioflSaveIterations;
}

void ConfigurationSingleton::setIoflStateElim(bool ioflStateElim) {
	iofl_state_elim = ioflStateElim;
}

void ConfigurationSingleton::setIoflWaitForCalls(bool ioflWaitForCalls) {
	iofl_wait_for_calls = ioflWaitForCalls;
}

void ConfigurationSingleton::setIoflElimOrder(EliminationOrder::ORDER ioflElimOrder) {
	iofl_elim_order = ioflElimOrder;
}

ConfigurationSingleton* ConfigurationSingleton::getInstance() {
	static ConfigurationSingleton instance;
	return &instance;
}

}
