/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef CONFIGURATION_H_
#define CONFIGURATION_H_

#include <vector>
#include <iostream>
#include "../mc/elimorder/EliminationOrder.h"

namespace scc_cex {

class ConfigurationSingleton {
private:
	ConfigurationSingleton() {
	}
	ConfigurationSingleton(const ConfigurationSingleton&) {
	}

	bool iofl_wait_for_calls;
	bool iofl_input_is_file;
	bool iofl_input_is_data;
	bool iofl_external_caller;
	bool iofl_benchmark_search;
	bool iofl_benchmark_heuristic;
	bool iofl_benchmark_conc;
	bool iofl_benchmark_selection;
	bool iofl_bound_pathsum;
	bool iofl_cex_local;
	bool iofl_cex_concrete;
	bool iofl_log;
	bool iofl_no_config;
	bool iofl_no_ModelChecking;
	bool iofl_only_ModelChecking;
	bool iofl_read_from_xml;
	bool iofl_state_elim;
	bool iofl_choose_degree;
	bool iofl_choose_membership;
	bool iofl_choose_probability;
	bool iofl_save_iterations;
	bool iofl_output_as_xml;
	bool iofl_output_as_dtmc;
	bool iofl_force_closure;
	bool iofl_force_abstract;
	bool iofl_force_global;
	bool iofl_force_probBound;
	bool iofl_increasing_elim_order;
	EliminationOrder::ORDER iofl_elim_order;

public:
	std::vector<bool> userInputConcretized;
	static ConfigurationSingleton* getInstance();
	bool autoConcretize;

	bool isIoflBenchmarkConc() const;
	bool isIoflBenchmarkHeuristic() const;
	bool isIoflBenchmarkSelection() const;
	bool isIoflBenchmarkSearch() const;
	bool isIoflBoundPathsum() const;
	bool isIoflCexConcrete() const;
	bool isIoflCexLocal() const;
	bool isIoflChooseDegree() const;
	bool isIoflChooseMembership() const;
	bool isIoflChooseProbability() const;
	bool isIoflExternalCaller() const;
	bool isIoflForceAbstract() const;
	bool isIoflForceClosure() const;
	bool isIoflForceGlobal() const;
	bool isIoflForceProbBound() const;
	bool isIoflIncreasingElimOrder() const;
	bool isIoflInputIsData() const;
	bool isIoflInputIsFile() const;
	bool isIoflLog() const;
	bool isIoflNoConfig() const;
	bool isIoflNoModelChecking() const;
	bool isIoflOnlyModelChecking() const;
	bool isIoflOutputAsDtmc() const;
	bool isIoflOutputAsXml() const;
	bool isIoflReadFromXml() const;
	bool isIoflSaveIterations() const;
	bool isIoflStateElim() const;
	bool isIoflWaitForCalls() const;
	EliminationOrder::ORDER getIoflElimOrder() const;
	void setIoflBenchmarkConc(bool ioflBenchmarkConc);
	void setIoflBenchmarkHeuristic(bool ioflBenchmarkHeuristic);
	void setIoflBenchmarkSelection(bool ioflBenchmarkSelection);
	void setIoflBenchmarkSearch(bool ioflBenchmarkSearch);
	void setIoflBoundPathsum(bool ioflBoundPathsum);
	void setIoflCexConcrete(bool ioflCexConcrete);
	void setIoflCexLocal(bool ioflCexLocal);
	void setIoflChooseDegree(bool ioflChooseDegree);
	void setIoflChooseMembership(bool ioflChooseMembership);
	void setIoflChooseProbability(bool ioflChooseProbability);
	void setIoflExternalCaller(bool ioflExternalCaller);
	void setIoflForceAbstract(bool ioflForceAbstract);
	void setIoflForceClosure(bool ioflForceClosure);
	void setIoflForceGlobal(bool ioflForceGlobal);
	void setIoflForceProbBound(bool ioflForceProbBound);
	void setIoflIncreasingElimOrder(bool ioflIncreasingElimOrder);
	void setIoflInputIsData(bool ioflInputIsData);
	void setIoflInputIsFile(bool ioflInputIsFile);
	void setIoflLog(bool ioflLog);
	void setIoflNoConfig(bool ioflNoConfig);
	void setIoflNoModelChecking(bool ioflNoModelChecking);
	void setIoflOnlyModelChecking(bool ioflOnlyModelChecking);
	void setIoflOutputAsDtmc(bool ioflOutputAsDtmc);
	void setIoflOutputAsXml(bool ioflOutputAsXml);
	void setIoflReadFromXml(bool ioflReadFromXml);
	void setIoflSaveIterations(bool ioflSaveIterations);
	void setIoflStateElim(bool ioflStateElim);
	void setIoflWaitForCalls(bool ioflWaitForCalls);
	void setIoflElimOrder(EliminationOrder::ORDER ioflElimOrder);
};

}

#endif /* CONFIGURATION_H_ */
