/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef XMLREADER_H_
#define XMLREADER_H_

#include "InputReader.h"
#include "../../data/GraphTypes.h"
#include "../IOWrapper.h"

#include <iostream>
#include <fstream>
#include <sstream>
#include <stdlib.h>
#include <utility>

using namespace scc_cex;
using namespace std;

namespace param_sccmc_io {

class XMLReader: public InputReader {
public:
	XMLReader(IOWrapper *wrapper);
	bool parse(std::istream *strm) const {
		getGraphFromXML(*strm);
		return true;
	}

	void readSCCInXML(Graph<PTYPE>* res, pugi::xml_node node) const;
	Graph<PTYPE>* getGraphFromXML(string xmlString) const;
	Graph<PTYPE>* getGraphFromXML(istream& istream) const;

private:
	IOWrapper *wrapper;
};
}
#endif /* XMLREADER_H_ */
