/*
 * This file is part of PARAM.
 *
 * PARAM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PARAM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PARAM. If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009-2011 Ernst Moritz Hahn (emh@cs.uni-saarland.de)
 */

#include "../prismparser/Model.h"
#include "../prismparser/Property.h"
#include "ExprToNumber.h"

namespace parametric {
using namespace prismparser;

ExprToNumber::ExprToNumber() {
	mapExpr = new ExprHashMap<unsigned>();
	mapNumber = new std::vector<Expr>();
}

ExprToNumber::~ExprToNumber() {
	delete mapExpr;
	delete mapNumber;
	for (unsigned propNr = 0; propNr < props.size(); propNr++) {
		delete props[propNr];
	}
}

void ExprToNumber::addProperty(const Property &prop) {
	props.push_back(new Property(prop));
}

void ExprToNumber::build() {
	for (unsigned propNr(0); propNr < props.size(); propNr++) {
		const Property *prop = props[propNr];
		buildExprToNumber(prop);
	}
}

void ExprToNumber::buildExprToNumber(const Property *prop) {
	if (ExprProp == prop->getType()) {
		Expr expr(prop->getExpr());
		if (0 == mapExpr->count(expr)) {
			(*mapExpr)[expr] = mapNumber->size();
			;
			mapNumber->push_back(expr);
		}
	} else {
		for (unsigned childNr(0); childNr < prop->arity(); childNr++) {
			buildExprToNumber(&((*prop)[childNr]));
		}
	}
}

const Expr &ExprToNumber::getExprByNumber(unsigned number) const {
	return (*mapNumber)[number];
}

unsigned ExprToNumber::getNumberByExpr(const Expr &expr) const {
	return (*mapExpr)[expr];
}

unsigned ExprToNumber::getNumExprs() const {
	return mapNumber->size();
}
}
