#include <cassert>
#include <limits>
#include <boost/dynamic_bitset.hpp>
#include "../rationalFunction/RationalFunction.h"
#include "PMC.h"

namespace parametric {
using namespace std;
using namespace rational;

PMM::ModelType PMC::getModelType() const {
	return PMM::PMC;
}

void copy(const PMC &input, PMC &output) {
	output.reserveRowsMem(input.getNumStates());
	output.reserveColsMem(input.getNumTrans());
	if (input.useRewards()) {
		output.reserveRewardsMem(input.getNumStates());
	}
	if (input.useTimes()) {
		output.reserveTimesMem(input.getNumStates());
	}
	for (PMM::state state(0); state < input.getNumStates(); state++) {
		if (input.isInit(state)) {
			output.addInit(state);
		}
		for (unsigned succ(0); succ < input.getNumSuccStates(state); succ++) {
			const unsigned succState(input.getSuccState(state, succ));
			RationalFunction succProb(input.getSuccProb(state, succ));
			output.addSucc(succState, succProb);
		}
		if (input.useRewards()) {
			for (PMM::state state(0); state < input.getNumStates(); state++) {
				output.addReward(input.getReward(state));
			}
		}
		if (input.useTimes()) {
			for (PMM::state state(0); state < input.getNumStates(); state++) {
				output.addTime(input.getTime(state));
			}
		}
		output.finishState();
	}
}

const RationalFunction &PMC::getReward(state state) const {
	assert(NULL != rewards);
	if (!(*absorbing)[state]) {
		return rewards[state];
	} else {
		return *zero;
	}
}

const RationalFunction &PMC::getTime(state state) const {
	assert(NULL != times);
	if (!(*absorbing)[state]) {
		return times[state];
	} else {
		return *one;
	}
}

void PMC::setReward(state state, const rational::RationalFunction &reward) {
	rewards[state] = reward;
}

void PMC::setTime(state state, const rational::RationalFunction &time) {
	times[state] = time;
}
}
