#include <set>
#include <boost/dynamic_bitset.hpp>
#include "../rationalFunction/RationalFunction.h"
#include "PMM.h"

namespace parametric {
using namespace std;

PMM::PMM() {
	inits = new set<PMM::state>();
	aps = NULL;
	absorbing = NULL;
	zero = new rational::RationalFunction(0);
	one = new rational::RationalFunction(1);
	rewards = NULL;
	times = NULL;
	rewIndex = 0;
	timeIndex = 0;
}

PMM::~PMM() {
	delete inits;
	if (NULL != aps) {
		delete aps;
	}
	if (NULL != absorbing) {
		delete absorbing;
	}
	delete zero;
	delete one;
	if (NULL != rewards) {
		delete[] rewards;
	}
	if (NULL != times) {
		delete[] times;
	}
}

void PMM::addInit(PMM::state state) {
	inits->insert(state);
}

bool PMM::isInit(PMM::state state) const {
	return (inits->find(state) != inits->end());
}

void PMM::reserveAPMem(unsigned numStates, unsigned numAPs_) {
	numAPs = numAPs_;
	aps = new boost::dynamic_bitset<>(numStates * numAPs);
}

void PMM::setAP(PMM::state state, unsigned ap, bool value) {
	(*aps)[state * numAPs + ap] = value;
}

bool PMM::isAP(PMM::state state, unsigned ap) const {
	return (*aps)[state * numAPs + ap];
}

unsigned PMM::getNumAPs() const {
	return numAPs;
}

void PMM::setAbsorbing(PMM::state state, bool absorb) {
	(*absorbing)[state] = absorb;
}

PMM::state PMM::getInvalidState() const {
	return numeric_limits<unsigned>::max();
}

void PMM::addReward(const rational::RationalFunction &rew) {
	rewards[rewIndex] = rew;
	rewIndex++;
}

void PMM::addTime(const rational::RationalFunction &time) {
	times[timeIndex] = time;
	timeIndex++;
}

void PMM::reserveRewardsMem(unsigned numEntries) {
	assert(NULL == rewards);
	rewards = new rational::RationalFunction[numEntries];
}

void PMM::reserveTimesMem(unsigned numEntries) {
	assert(NULL == times);
	times = new rational::RationalFunction[numEntries];
}

bool PMM::useRewards() const {
	return rewards != NULL;
}

bool PMM::useTimes() const {
	return times != NULL;
}
}
