/*
 * This file is part of a parser for an extension of the PRISM language.
 *
 * This is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * The parser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the program this parser part of.
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2007-2010 Bjoern Wachter (Bjoern.Wachter@comlab.ox.ac.uk)
 * Copyright 2009-2012 Ernst Moritz Hahn (emh@cs.uni-saarland.de)
 */

#ifndef MODEL_H
#define MODEL_H

// TODO remove
#include <vector>
// TODO remove
#include "Expr.h"
#include "Types.h"

namespace prismparser {
class Property;
class Module;
class Command;
class Alternative;
class PRISMParser;
class ModelImpl;
class ModuleImpl;
class CommandImpl;
class AlternativeImpl;

typedef std::string Action;

class Model {
public:
	Model();
	Model(const Model &);
	~Model();
	Model &operator=(const Model &);
	const Module &getModule(const std::string &) const;
	const Expr &getInitial() const;
	const Expr &getDefaultInitialValue(const Expr &) const;
	unsigned getNumCommands() const;
	const Command &getCommand(unsigned) const;
	// TODO remove
	const std::vector<Expr> &getUserPreds() const;
	unsigned getNumProperties() const;
	const Property &getProperty(unsigned) const;
	// TODO remove
	const std::vector<Expr> &getInvar() const;
	bool isParameterVariable(const Expr &) const;
	ModelType getModelType() const;
	const std::string &toString() const;
	unsigned getNumVariables() const;
	const Expr &getVariable(unsigned) const;
	const Expr &getVariable(const std::string &) const;
	const Expr &getStateReward(unsigned) const;
	const Expr &getTransReward(unsigned, const std::string &) const;

	void flatten();
	void ctmcDivideCommands();
	void fixDeadlocks();
private:
	friend class PRISMParserImpl;

	ModelImpl *impl;
};

class Module {
public:
	Module();
	Module(const Module &);
	~Module();
	Module &operator=(const Module &);
	const std::string &getName() const;
	const std::string &toString() const;

private:
	friend class ModelImpl;
	friend class ModuleImpl;
	friend class PRISMParserImpl;

	ModuleImpl *impl;
};

struct Command {
	Command();
	Command(const Command &);
	~Command();
	Command &operator=(const Command &);
	const Expr &getGuard() const;
	const std::string &getAction() const;
	unsigned getNumAlternatives() const;
	const Alternative &getAlternative(unsigned) const;
	const std::string &toString() const;

private:
	friend class Model;
	friend class ModelImpl;
	friend class AbsModel;
	friend class CommandImpl;
	friend class PRISMParserImpl;

	CommandImpl *impl;
};

class Alternative {
public:
	Alternative();
	Alternative(const Alternative &);
	~Alternative();
	Alternative &operator=(const Alternative &);
	const Expr &getWeight() const;
	const Expr &getAssgnToVar(const Expr &) const;
	const std::string &toString() const;

private:
	friend class AlternativeImpl;
	friend class CommandImpl;
	friend class PRISMParserImpl;
	friend class ModelImpl;

	AlternativeImpl *impl;
};

std::ostream &operator<<(std::ostream &, const Model &);
std::ostream &operator<<(std::ostream &, const Module &);
std::ostream &operator<<(std::ostream &, const Command &);
std::ostream &operator<<(std::ostream &, const Alternative &);
}

#endif
