/*
 * This file is part of a parser for an extension of the PRISM language.
 *
 * This is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * The parser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the program this parser part of.
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2007-2010 Bjoern Wachter (Bjoern.Wachter@comlab.ox.ac.uk)
 * Copyright 2009-2012 Ernst Moritz Hahn (emh@cs.uni-saarland.de)
 */

#ifndef __PROPERTY_H
#define __PROPERTY_H

#include <iosfwd>
#include <string>
#include "Types.h"

namespace prismparser {
class Expr;
class PRISMParserImpl;
class PropertyImpl;
class ProbBoundImpl;
class FilterImpl;
class TimeBoundImpl;

class TimeBound {
	friend std::ostream &operator<<(std::ostream &, const TimeBound &);
public:
	TimeBound();
	~TimeBound();
	const std::string &toString() const;
	TimeType getType() const;
	double getLowerBound() const;
	double getUpperBound() const;
	bool hasUpperBound() const;
private:
	friend class PRISMParserImpl;
	friend class Property;
	TimeBoundImpl *impl;
};

class ProbBound {
	friend std::ostream &operator<<(std::ostream &, const ProbBound &);
public:
	ProbBound();
	~ProbBound();
	const std::string &toString() const;
	bool isMin() const;
	bool isMinOrMax() const;
	double getBoundAsDouble() const;
	BoundType getType() const;
	const Expr &getBound() const;
private:
	friend class PRISMParserImpl;
	ProbBoundImpl *impl;
};

class Filter {
	friend std::ostream &operator<<(std::ostream &, const PropertyImpl &);
public:
	Filter();
	~Filter();
	const Expr &getExpr() const;
	FilterType getType() const;
private:
	friend class PRISMParserImpl;
	friend class Property;
	friend class PropertyImpl;
	FilterImpl *impl;
};

class Property {
	friend std::ostream &operator<<(std::ostream &, const Property &);
public:
	Property();
	Property(const Property &);
	~Property();
	Property &operator=(const Property &);
	const std::string &toString() const;
	unsigned arity() const;
	const Property &operator[](unsigned) const;
	PropType getType() const;
	const ProbBound &getProbBound() const;
	const TimeBound &getTimeBound() const;
	bool hasFilter() const;
	const Filter &getFilter() const;
	unsigned getRewStructNr() const;
	const double getTime() const;
	const Expr &getExpr() const;
private:
	friend class PRISMParserImpl;
	friend class PropertyImpl;
	PropertyImpl *impl;
};
}

#endif
