#ifndef PROPERTY_IMPL_H
#define PROPERTY_IMPL_H

#include <vector>

namespace prismparser {
class Property;
class PRISMParserImpl;
class TimeBound;
class ProbBound;
class Filter;

class TimeBoundImpl {
	friend std::ostream &operator<<(std::ostream &, const TimeBoundImpl &);
	friend class TimeBound;
	friend class PRISMParserImpl;
	friend class PropertyImpl;
	friend class Property;
private:
	TimeBoundImpl();
	~TimeBoundImpl();
	const std::string &toString() const;
	TimeType getType() const;
	double getLowerBound() const;
	double getUpperBound() const;
	bool hasUpperBound() const;

	mutable std::string str;
	double t1, t2;
};

class ProbBoundImpl {
	friend class ProbBound;
	friend class Property;
	friend class PRISMParserImpl;
	friend std::ostream &operator<<(std::ostream &, const ProbBoundImpl &);
private:
	ProbBoundImpl();
	~ProbBoundImpl();
	const std::string &toString() const;
	bool isMin() const;
	bool isMinOrMax() const;
	double getBoundAsDouble() const;
	const Expr &getBound() const;
	BoundType getType() const;

	mutable std::string str;
	BoundType type;
	Expr *bound;
	bool min;
	bool minOrMax;
};

class FilterImpl {
	friend class Filter;
	friend class Property;
	friend class PropertyImpl;
	friend class PRISMParserImpl;
	friend std::ostream &operator<<(std::ostream &, const PropertyImpl &);
private:
	FilterImpl();
	~FilterImpl();
	const Expr &getExpr() const;
	FilterType getType() const;

	Expr *expr;
	FilterType type;
};

class PropertyImpl {
	friend class Property;
	friend class PRISMParserImpl;
	friend std::ostream &operator<<(std::ostream &, const PropertyImpl &);
private:
	PropertyImpl();
	~PropertyImpl();
	const std::string &toString() const;
	unsigned arity() const;
	const Property &operator[](unsigned) const;
	PropType getType() const;
	const ProbBound &getProbBound() const;
	const TimeBound &getTimeBound() const;
	bool hasFilter() const;
	const Filter &getFilter() const;
	unsigned getRewStructNr() const;
	const double getTime() const;
	const Expr &getExpr() const;

	unsigned refs;
	PropType type;
	std::vector<Property *> children;
	mutable std::string str;
	Filter *filter;
	unsigned rewStructNr;
	ProbBound *probBound;
	double doubleTime;
	TimeBound *timeBound;
	Expr *expr;
};
}
#endif
