/*
 * This file is part of a parser for an extension of the PRISM language.
 *
 * This is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * The parser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the program this parser part of.
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2012 Ernst Moritz Hahn (emh@cs.uni-saarland.de)
 */

#ifndef __REWARD_H
#define __REWARD_H

#include <string>
#include <map>
#include <vector>
#include <utility>

#include "Expr.h"

namespace prismparser {
class Reward {
	friend std::ostream &operator<<(std::ostream &, const Reward &);
public:
	void addStateReward(const Expr &, const Expr &);
	void addTransReward(const std::string &, const Expr &, const Expr &);
	const Expr &getStateRewardExpr() const;
	const Expr &getTransRewardExpr(const std::string &) const;
	const std::string &toString() const;
private:
	typedef std::vector<std::pair<Expr, Expr> > StateRewards;
	typedef std::map<std::string, std::vector<std::pair<Expr, Expr> > > TransRewards;
	StateRewards stateRewards;
	TransRewards transRewards;

	mutable Expr stateRewExpr;
	mutable std::map<std::string, Expr> transRewExpr;
	mutable std::string str;
};
}

#endif
