/*
 * This file is part of a parser for an extension of the PRISM language.
 *
 * This is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * The parser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the program this parser part of.
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2007-2010 Bjoern Wachter (Bjoern.Wachter@comlab.ox.ac.uk)
 * Copyright 2009-2012 Ernst Moritz Hahn (emh@cs.uni-saarland.de)
 */

#include "System.h"
#include <iostream>

namespace prismparser {
using namespace std;

System::System() {
	left = NULL;
	right = NULL;
}

System::~System() {
	if (NULL != left) {
		delete left;
	}
	if (NULL != right) {
		delete right;
	}
}

ostream &operator<<(std::ostream &os, const System &system) {
	switch (system.type) {
	case System::IdentifierSystem:
		os << system.identifier;
		break;
	case System::RenameSystem:
		os << "(";
		os << *(system.left);
		os << "){";
		for (map<string, string>::const_iterator it = system.rename.begin(); it != system.rename.end(); it++) {
			if (it != system.rename.begin()) {
				os << ",";
			}
			os << it->first << "<-" << it->second;
		}
		os << "}";
		break;
	case System::HideSystem:
		os << "(";
		os << *(system.left);
		os << ")/{";
		for (set<string>::const_iterator it = system.hide.begin(); it != system.hide.end(); it++) {
			if (it != system.hide.begin()) {
				os << ",";
			}
			os << *it;
		}
		os << "}";
		break;
	case System::AlparSystem:
		os << "(";
		os << *system.left;
		os << ")||(";
		os << *system.right;
		os << ")";
		break;
	case System::AsparSystem:
		os << "(";
		os << *system.left;
		os << ")|||(";
		os << *system.right;
		os << ")";
		break;
	case System::ResparSystem:
		os << "(";
		os << *system.left;
		os << ")|[";
		for (set<string>::const_iterator it = system.actions.begin(); it != system.actions.end(); it++) {
			if (it != system.actions.begin()) {
				os << ",";
			}
			os << *it;
		}
		os << "]|(";
		os << *system.right;
		os << ")";
		break;
	}
	return os;
}
}
