/*
 * This file is part of a parser for an extension of the PRISM language.
 *
 * This is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * The parser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the program this parser part of.
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2007-2010 Bjoern Wachter (Bjoern.Wachter@comlab.ox.ac.uk)
 * Copyright 2009-2012 Ernst Moritz Hahn (emh@cs.uni-saarland.de)
 */

#ifndef PRISMPARSER_SYSTEM
#define PRISMPARSER_SYSTEM

#include <string>
#include <set>
#include <map>

namespace prismparser {
class System {
public:
	System();
	~System();

	enum SystemType {
		IdentifierSystem, RenameSystem, HideSystem, AlparSystem, AsparSystem, ResparSystem
	};
	typedef std::map<std::string, std::string> RenameMap;
	typedef std::set<std::string> HideSet;

	SystemType type;
	std::string identifier;
	std::set<std::string> actions;
	RenameMap rename;
	HideSet hide;
	System *left;
	System *right;
};

std::ostream &operator<<(std::ostream &, const System &);
}

#endif
