#ifndef VAR_TYPE_H
#define VAR_TYPE_H

namespace prismparser {
enum VarType {
	NullVar, BoolVar, IntVar, RangeVar, RealVar
};

enum ExprType {
	VarExpr, BoolExpr, RatExpr,

	NotExpr, AndExpr, OrExpr, ImplExpr,

	EqExpr, NeqExpr, LtExpr, GtExpr, LeExpr, GeExpr,

	PlusExpr, MinusExpr, UminusExpr, MultExpr, DivExpr, PowExpr,

	IteExpr, MinExpr, MaxExpr,

	FloorExpr, CeilExpr
};

enum PropType {
	ExprProp,
	AndProp,
	OrProp,
	ImplProp,
	NegProp,
	NextProp,
	UntilProp,
	QuantProp,
	SteadySProp,
	ReachRewProp,
	CumulRewProp,
	InstRewProp,
	SteadySRewProp
};

enum TimeType {
	GeTime, LeTime, IntervalTime, UnboundedTime
};

enum BoundType {
	GrBound, GeBound, LeBound, LtBound, EqBound, DkBound
};

enum ModelType {
	DTMC, MDP, CTMC
};

enum FilterType {
	MinFilter,
	MaxFilter,
	CountFilter,
	SumFilter,
	AvgFilter,
	FirstFilter,
	RangeFilter,
	ForallFilter,
	ExistsFilter,
	StateFilter,
	ArgminFilter,
	ArgmaxFilter,
	PrintFilter
};
}

#endif
