/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef SCC_MC_H_
#define SCC_MC_H_

#include "ModelChecker.h"

namespace scc_cex {

class SccMc: public ModelChecker {
public:
	SccMc() {
	}
	~SccMc() {
	}

protected:
	void modelCheck_common(Graph<PTYPE>*);

private:
	void abstraction(Graph<PTYPE>* g);
	void strongComponents(Graph<PTYPE>* g) const;
	void tarjan(Vertex<PTYPE> *v, Graph<PTYPE>* g, vtx_vector & S, int & max_dfs) const;
	void reduceGraph(Graph<PTYPE>* g) const;
	void computeWeight(Vertex<PTYPE> *in, Vertex<PTYPE> *out) const;
};

}
#endif /* SCC_MC_H_ */
