/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef CONNECTIVITY_ORDER_H_
#define CONNECTIVITY_ORDER_H_

#include "EliminationOrder.h"

namespace scc_cex {

bool hasLowerConnectivity(Vertex<PTYPE>* v1, Vertex<PTYPE>* v2) {
	return v1->outEdges.size() + v1->inEdges.size() < v2->outEdges.size() + v2->inEdges.size();
}

/**
 * Vertices are ordered by their connectivity, i.e. number of outgoing edges
 */
class ConnectivityOrder: public EliminationOrder {
public:
	ConnectivityOrder(bool increasing) :
		EliminationOrder(increasing) {
	}

	void init(Graph<PTYPE>*g) {
		for (vtx_it iter = g->allVertices.begin(); iter != g->allVertices.end(); iter++) {
			if (isPossible(*iter)) {
				orderingVtx.push_back(*iter);
			}
		}

		//Sort vertices according to their connectivity
		sort(orderingVtx.begin(), orderingVtx.end(), hasLowerConnectivity);

		initCurrentPos();
	}
};

}
#endif /* CONNECTIVITY_ORDER_H_ */
