/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef DISTANCE_ORDER_H_
#define DISTANCE_ORDER_H_

#include "EliminationOrder.h"

namespace scc_cex {

/**
 * Vertices are ordered by distance to targets at beginning
 */
class DistanceOrder: public EliminationOrder {
public:
	DistanceOrder(bool increasing) :
			EliminationOrder(increasing) {
	}

	void init(Graph<PTYPE>* g) {
		//Compute distances to target states by breath-first search
		vector<Vertex<PTYPE>*> tmpList;

		//Initialization of queue
		for (vtx_it iter = g->outputVertices.begin(); iter != g->outputVertices.end(); iter++) {
			tmpList.push_back(*iter);
			(*iter)->distance = 0;
		}

		for (unsigned int i = 0; i < tmpList.size(); i++) {
			//Iterator can not be used, because is invalidated after reallocation
			Vertex<PTYPE>* current = tmpList[i];
			unsigned int distance = current->distance + 1;

			//Search for unprocessed vertices
			for (edge_it iterEdge = current->inEdges.begin(); iterEdge != current->inEdges.end(); iterEdge++) {
				Vertex<PTYPE>* v = (*iterEdge)->source;
				if (v->distance > distance) {

					assert(std::find(tmpList.begin(), tmpList.end(), v) == tmpList.end());

					//Add to queue
					tmpList.push_back(v);
					v->distance = distance;

					if (isPossible(v)) {
						orderingVtx.push_back(v);
					}
				}
			}
		}

		initCurrentPos();
	}
};

}
#endif /* DISTANCE_ORDER_H_ */
