/**
 * Parametric SCC based Model Checking
 *  
 * This is a stand-alone tool which performs model checking
 * for parametric discrete-time Markov Chains (PDTMCs).
 * 
 * Copyright (c) 2013 RWTH Aachen University.
 * Authors: Florian Corzilius, Nils Jansen, Matthias Volk
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * http://www.gnu.org/licenses/gpl.html.
 * 
 * 
 * Main Contact:
 * 
 * Nils Jansen
 * Theory of Hybrid Systems
 * RWTH Aachen
 * 52056 Aachen
 * Germany
 * nils.jansen@cs.rwth-aachen.de
 */

#ifndef RANDOM_ORDER_H_
#define RANDOM_ORDER_H_

#include "EliminationOrder.h"

namespace scc_cex {

//random generator function:
ptrdiff_t random(ptrdiff_t i) {
	return rand() % i;
}

//pointer object to it:
ptrdiff_t (*p_random)(ptrdiff_t) = random;

/**
 * Vertices are ordered randomly
 * Increasing/decreasing has no notable effect
 */
class RandomOrder: public EliminationOrder {
public:
	RandomOrder(bool increasing) :
		EliminationOrder(increasing) {
	}

	void init(Graph<PTYPE> *g) {
		srand(unsigned(time(NULL)));

		//Initialize vector
		for (vtx_it iter = g->allVertices.begin(); iter != g->allVertices.end(); iter++) {
			if (isPossible(*iter)) {
				orderingVtx.push_back(*iter);
			}
		}

		//Shuffle
		random_shuffle(orderingVtx.begin(), orderingVtx.end(), p_random);

		initCurrentPos();
	}
};

}
#endif /* BACKWARDS_ORDER_H_ */
