%{
int i; // vertex counter
#include<stdio.h> 
%}

%token V C F L N 

%left L 
%left N 

%%

s : a
  {
    $$=++i;
    printf("%d [label=\"%d [s:a]\"]\n",$$,$$);
    printf("%d->%d\n",$1,$$);
  }
  | a s
  {
    $$=++i;
    printf("%d [label=\"%d [s:as]\"]\n",$$,$$);
    printf("%d->%d\n",$1,$$);
    printf("%d->%d\n",$2,$$);
  }
  ;
a : V '=' e ';'
  {
    $$=++i;
    printf("%d [label=\"%d [a:V=e;]\"]\n",$$,$$);
    printf("%d->%d\n",$3,$$);
  }
  ;
e : e L e
  {
    $$=++i;
    printf("%d [label=\"%d [e:eLe]\"]\n",$$,$$);
    printf("%d->%d\n",$1,$$);
    printf("%d->%d\n",$3,$$);
  }
  | e N e
  {
    $$=++i;
    printf("%d [label=\"%d [e:eNe]\"]\n",$$,$$);
    printf("%d->%d\n",$1,$$);
    printf("%d->%d\n",$3,$$);
  }
  | F '(' e ')'
  {
    $$=++i;
    printf("%d [label=\"%d [e:F(e)]\"]\n",$$,$$);
    printf("%d->%d\n",$3,$$);
  }
  | V
  {
    $$=++i;
    printf("%d [label=\"%d [e:V]\"]\n",$$,$$);
  }
  | C
  {
    $$=++i;
    printf("%d [label=\"%d [e:C]\"]\n",$$,$$);
  }
  ;

%%

int yyerror(char *msg) { printf("%s \n",msg); return -1; }

int main(int argc,char** argv)
{
  FILE *source_file=fopen(argv[1],"r");
  lexinit(source_file); 
  i=0;
  printf("digraph {\nrankdir=BT;\n"); 
  yyparse(); 
  printf("}\n");
  fclose(source_file);
  return 0;
}

