%{

#include<stdio.h> // for FILE
#include<iostream> // for cout

extern int lineno;
extern int yylex();
extern void lexinit(FILE*);
extern int yyerror(const char*);

%}

%token V C F L N 

%%

s : a
  | a s
  ;
a : V '=' e ';'
e : e L t
  | t
  ;
t : t N f
  | f
  ;
f : F '(' e ')'
  | V
  | C
  ;

%%

int yyerror(const char *msg)
{
        std::cout << "Error: " << msg <<" in line "<< lineno <<" of the input file."<< std::endl;
        exit(-1);
}


int main(int argc,char** argv)
{
  FILE *source_file=fopen(argv[1],"r");
  lexinit(source_file); 
  yyparse();
  fclose(source_file);
  return 0;
}

