%{ 
#include "parser.tab.h"
int lineno=1;
%}

whitespace      [ \t]+
newline         \n
variable	[a-z]
constant	[0-9]

%%

{whitespace} 	{ }
{newline} 	{ lineno++; }
"sin" 		{ return F; } 
"+" 		{ return L; } 
"*" 		{ return N; } 
{variable} 	{ return V; }
{constant} 	{ return C; }
. 		{ return yytext[0]; }

%%

void lexinit(FILE *source)
{
  yyin=source;
}
