%{

#include <stdio.h>
#include <stdlib.h>
#include "ast.h"

extern int yylex();
extern void lexinit(FILE*);

static int sacvc; // SAC variable counter

void get_memory(YYSTYPE* v) {
  v->c=malloc(BUFFER_SIZE*sizeof(char));
}
void free_memory(YYSTYPE* v) {
  if (v->c) free(v->c); 
}

%}

%token V C F L N

%left L
%left N

%%

sl_program : s
  {
    printf("%s",$1.c);
    free_memory(&$1);
  }
  ;
s : a
  | a s
  {
    get_memory(&$$);
    sprintf($$.c,"%s%s",$1.c,$2.c);
    free_memory(&$1); free_memory(&$2);
  }
  ;
a : V '=' 
  {
    sacvc=0;
  }
  e ';'
  { 
    get_memory(&$$); 
    sprintf($$.c,"%s%s_=v%d_; %s=v%d; \n",
                 $4.c,$1.c,$4.j,$1.c,$4.j);
    free_memory(&$1); free_memory(&$4); 
  }
  ;
e : e L e
  {
    $$.j=sacvc++; 
    get_memory(&$$); 
    sprintf($$.c,"%s%sv%d_=v%d_%sv%d_; v%d=v%d%sv%d; \n",
                  $1.c,$3.c,$$.j,$1.j,$2.c,$3.j,
                  $$.j,$1.j,$2.c,$3.j);
    free_memory(&$1); 
  }
  |e N e
  {
    if (!strcmp($2.c,"*")) {
      $$.j=sacvc++; 
      get_memory(&$$); 
      sprintf($$.c,
        "%s%sv%d_=v%d_*v%d+v%d*v%d_; v%d=v%d%sv%d; \n",
         $1.c,$3.c,$$.j,$1.j,$3.j,$1.j,$3.j,
         $$.j,$1.j,$2.c,$3.j);
      free_memory(&$1); 
    }
  }
  | F '(' e ')'
  {
    if (!strcmp($2.c,"sin")) {
      $$.j=sacvc++; 
      get_memory(&$$); 
      sprintf($$.c,"%sv%d_=cos(v%d)*v%d_; v%d=sin(v%d);\n",
                   $3.c,$$.j,$3.j,$3.j,$$.j,$3.j);
      free_memory(&$3); 
    }
  }
  | V
  {
    $$.j=sacvc++; 
    get_memory(&$$); 
    sprintf($$.c,"v%d_=%s_; v%d=%s;\n",$$.j,$1.c,$$.j,$1.c);
    free_memory(&$1); 
  }
  | C
  {
    $$.j=sacvc++; 
    get_memory(&$$); 
    sprintf($$.c,"v%d_=0; v%d=%s;\n",$$.j,$$.j,$1.c);
    free_memory(&$1); 
  }
  ;

%%

int yyerror(char *msg) { 
  printf("ERROR: %s \n",msg); 
  return -1; 
}

int main(int argc,char** argv) {
  FILE *source_file=fopen(argv[1],"r");
  lexinit(source_file); 
  yyparse();
  fclose(source_file);
  return 0;
}

