%{ 
#include "ast.h"
#include "parser.tab.h"

#include<stdlib.h> // malloc
#include<string.h> // strcpy

void to_parser() {
  yylval.c=(char*)malloc(BUFFER_SIZE*sizeof(char));
  strcpy(yylval.c,yytext);
}
%}

whitespace      [ \t\n]+
variable	[a-z]
constant	[0-9]

%%

{whitespace} 	{ }
"sin" 		{ to_parser(); return F; } 
"+"             { to_parser(); return L; }
"*"             { to_parser(); return N; }
{variable}      { to_parser(); return V; }
{constant}      { to_parser(); return C; }
. 		{ return yytext[0]; }

%%

void lexinit(FILE *source) { yyin=source; }
