/*
 * AlgorithmWrapper.h
 *
 *  Created on: 13.02.2012
 *      Author: Markus Bals
 */

#ifndef ALGORITHMWRAPPER_H_
#define ALGORITHMWRAPPER_H_

#include "ignf.h"

namespace IGNF {
struct Runtimes {
	timeval simple;
	timeval basic;
	timeval incremental;
};

class AlgorithmWrapper {

private:
	BasicAlgorithmSimple m_simple;
	BasicAlgorithm m_basic;
	IncrementalAlgorithm m_incremental;
	StringGrammar m_grammar;
	Clock m_clock;
	vector<Runtimes> m_performance;
	vector<string> m_insertedProductions;
	map<string,bool> m_options;

public:
	AlgorithmWrapper(map<string,bool> options);
	void runOnGrammarFile(string inputfilename);
	bool append(string production);

	void showEncodingTable();

	void showProductionsSimple();
	void showProductionsBasic();
	void showProductionsIncremental();
	void showOriginalProductions();
	void showRuntimes();

private:
	void insertProduction(StringProduction strProduction);
};

} /* namespace IGNF */
#endif /* ALGORITHMWRAPPER_H_ */
