/*
 * BasicAlgorithm.h
 *
 *  Created on: 23.01.2012
 *      Author: Markus Bals
 */

#ifndef BASICALGORITHM_H_
#define BASICALGORITHM_H_

#include "ignf.h"

namespace IGNF {

class BasicAlgorithm {
public:
	BasicAlgorithm();
	virtual ~BasicAlgorithm();

	void runOnGrammarFile(string filename);
	void runOnGrammar(StringGrammar grammar);
	void showProductions();

private:
	StringGrammar m_grammar;
	Worklist<WorklistProduction> m_orderingList, m_greibachList, m_finalList;

	void clearAlgorithm();
	void initWorklists();
	void checkForWorklist(Production production);
	void checkForWorklist(set<Production> productions);
	void processWorklist(Worklist<WorklistProduction> *worklist);

	void replaceByLeftDerivations(Production production);
	void removeDirectLeftRecursion(Production production);

};

} /* namespace IGNF */
#endif /* BASICALGORITHM_H_ */
