/*
 * BasicAlgorithmSimple.cpp
 *
 *  Created on: 01.03.2012
 *      Author: mbals
 */

#include "ignf.h"

namespace IGNF {

BasicAlgorithmSimple::BasicAlgorithmSimple() {
}


void BasicAlgorithmSimple::runOnGrammarFile(string filename) {
	m_grammar.initFromFile(filename);
    runOnGrammar(m_grammar);
}


void BasicAlgorithmSimple::runOnGrammar(StringGrammar grammar) {
	cout << "Starting basic algorithm (simple version).\n";
	m_grammar = grammar;

	if ( m_grammar.getProductions().size() < 1 ) {
#ifdef DEBUG
		cout << "Grammar is empty, so there is nothing to do.\n";
#endif
		return;
	}
#ifdef DEBUG
	cout << m_grammar.getEncodingTableString();
	cout << m_grammar.getProductionsString();
	cout << "\nGrammar was read, starting algorithm.\n";

	cout << "\nOrdering and removal of direct left recursions:\n";
#endif
	orderAllProductions();
#ifdef DEBUG
	cout << "\nEstablish greibach for original symbols:\n";
#endif
	greibachAllProductions();
#ifdef DEBUG
	cout << "\nEstablish greibach property for new right recursive symbols:\n";
#endif
	finalizeAllProductions();
	cout << "Basic algorithm (simple version) terminated successfully.\n";
}

void BasicAlgorithmSimple::showProductions() {
	cout << "Basic Algorithm (simple version) Productions:\n"
			<< m_grammar.getProductionsString(set<Production>(), true);
}


void BasicAlgorithmSimple::orderAllProductions() {
	set<Production> allProductions = m_grammar.getProductions();
	if ( allProductions.empty() )
		return;
	set<Production>::iterator it = allProductions.begin();
	Symbol curLHS = (*it).first;

	while ( it != allProductions.end() ) {
		if ( !StringGrammar::ordered(*it) )
			orderProduction(*it);
		it++;
		if ( it == allProductions.end() || (*it).first != curLHS ) {
			removeAllRecursions(curLHS);
			if ( it != allProductions.end() )
			  curLHS = (*it).first;
		}
	}
}

void BasicAlgorithmSimple::orderProduction(Production prod) {
	set<Production> newProductions = replaceByLeftDerivations(prod);
	set<Production>::iterator it = newProductions.begin();

	while ( it != newProductions.end() ) {
		if ( !StringGrammar::ordered(*it) )
			orderProduction(*it);
		it++;
	}
}

void BasicAlgorithmSimple::removeAllRecursions(Symbol lhs) {
	set<Production> allProductions = m_grammar.getProductions(lhs);
	if ( allProductions.empty() )
		return;
	set<Production>::iterator it = allProductions.begin();
	while ( it != allProductions.end() ) {
		if ( StringGrammar::recursive(*it) )
			removeDirectLeftRecursion(*it);
		it++;
	}
}

void BasicAlgorithmSimple::greibachAllProductions() {
	set<Production> allProductions = m_grammar.getProductions();
	if ( allProductions.empty() )
		return;
	set<Production>::reverse_iterator it = allProductions.rbegin();

	while ( it != allProductions.rend() ) {
		if ( !IS_RECURSIVE_SYMBOL((*it).first) && !StringGrammar::greibach(*it) )
			replaceByLeftDerivations(*it);
		it++;
	}
}

void BasicAlgorithmSimple::finalizeAllProductions() {
	set<Production> allProductions = m_grammar.getProductions();
	if ( allProductions.empty() )
		return;
	set<Production>::reverse_iterator it = allProductions.rbegin();

	while ( it != allProductions.rend() ) {
		if ( !IS_RECURSIVE_SYMBOL((*it).first) )
			break;
		if ( !StringGrammar::greibach(*it) )
			replaceByLeftDerivations(*it);
		it++;
	}
}


set<Production> BasicAlgorithmSimple::replaceByLeftDerivations(Production production) {
	set<Production> inserted = m_grammar.getProductions(production.second[0]);
	set<Production> newProductions =
			StringGrammar::getLeftDerivations(production, inserted);
#ifdef DEBUG
	cout << "removing " << m_grammar.getProductionString(production) <<
			" and inserting " << m_grammar.getProductionsString(newProductions);
#endif
	m_grammar.removeProduction(production);
	m_grammar.addProductions(newProductions);
	return newProductions;
}

void BasicAlgorithmSimple::removeDirectLeftRecursion(Production production) {
	set<Production> nonRecursive = m_grammar.getProductions(production.first);
	set<Production>::iterator it = nonRecursive.begin();

	while ( it != nonRecursive.end() ) {
		if ( StringGrammar::recursive(*it) )
			nonRecursive.erase(*it);
		it++;
	}

	bool rrExists = m_grammar.checkRecursiveSymbol(production.first);

	set<Production> newProductions =
			StringGrammar::getRightRecursiveReplacement(production, nonRecursive, rrExists);
#ifdef DEBUG
	cout << "  removing " << m_grammar.getProductionString(production) <<
			" and inserting " << m_grammar.getProductionsString(newProductions);
#endif
	m_grammar.removeProduction(production);
	m_grammar.addProductions(newProductions);
}


} /* namespace IGNF */
