/*
 * BasicAlgorithmSimple.h
 *
 *  Created on: 01.03.2012
 *      Author: mbals
 */

#ifndef BASICALGORITHMSIMPLE_H_
#define BASICALGORITHMSIMPLE_H_

#include "ignf.h"

namespace IGNF {

class BasicAlgorithmSimple {
public:
	BasicAlgorithmSimple();

	void runOnGrammarFile(string filename);
	void runOnGrammar(StringGrammar grammar);
	void showProductions();
private:
	StringGrammar m_grammar;

	void orderAllProductions();
	void orderProduction(Production prod);
	void removeAllRecursions(Symbol lhs);
	void greibachAllProductions();
	void finalizeAllProductions();

	set<Production> replaceByLeftDerivations(Production production);
	void removeDirectLeftRecursion(Production production);

};

} /* namespace IGNF */
#endif /* BASICALGORITHMSIMPLE_H_ */
