/*
 * Clock.cpp
 *
 *  Created on: 13.02.2012
 *      Author: mbals
 */

#include "ignf.h"

namespace IGNF {

Clock::Clock() {
}

void Clock::resetClock(int clockID) {
	gettimeofday(&m_clocks[clockID], NULL);
}

timeval Clock::getTimeval(int clockID) {
	timeval stopTime;
	gettimeofday(&stopTime, NULL);
	return timediff(m_clocks[clockID], stopTime);
}

string Clock::getTimevalString(int clockID) {
	return time2string(getTimeval(clockID));
}

timeval Clock::timediff(const timeval start, const timeval end) {
  timeval diff;
  diff.tv_sec = end.tv_sec - start.tv_sec;
  diff.tv_usec = end.tv_usec - start.tv_usec;
  if ( diff.tv_usec < 0 ) {
    diff.tv_usec += 1000000;
    diff.tv_sec -= 1;
  }
  return diff;
}

timeval Clock::timesum(const timeval val1, const timeval val2) {
  timeval sum;
  sum.tv_sec = val1.tv_sec + val2.tv_sec;
  sum.tv_usec = val1.tv_usec + val2.tv_usec;
  if ( sum.tv_usec > 1000000 ) {
    sum.tv_usec -= 1000000;
    sum.tv_sec += 1;
  }
  return sum;
}

string Clock::time2string(const timeval val, const bool unit) {
  stringstream ss;
  ss << (val.tv_sec) << ".";
  long cap = 100000;
  while ( val.tv_usec < cap ) {
    ss << "0";
    cap /= 10;
  }
  ss << (val.tv_usec);
  if ( unit )
	  ss << " sec";

  return ss.str();
}

} /* namespace IGNF */
