/*
 * Clock.h
 *
 *  Created on: 13.02.2012
 *      Author: Markus Bals
 */

#ifndef CLOCK_H_
#define CLOCK_H_

#include "ignf.h"

namespace IGNF {

class Clock {
private:
	map<int, timeval> m_clocks;

public:
	Clock();

	void resetClock(int clockID=0);
	timeval getTimeval(int clockID=0);
	string getTimevalString(int clockID=0);

	static timeval timediff(const timeval start, const timeval end);
	static timeval timesum(const timeval val1, const timeval val2);
	static string time2string(const timeval val, const bool unit=false);
};

} /* namespace IGNF */
#endif /* CLOCK_H_ */
