/*
 * Forest.cpp
 *
 *  Created on: 06.02.2012
 *      Author: mbals
 */

#include "ignf.h"

namespace IGNF {

Forest::Forest() {
}

Forest::~Forest() {
}

TreeNode*  Forest::insertProduction(StringProduction production) {
	return insertProduction(m_grammar.encodeProduction(production));
}

TreeNode* Forest::insertProduction(Production encoded) {
	Symbol lhs = encoded.first;

	if ( IS_RECURSIVE_SYMBOL(lhs) )
		m_grammar.checkRecursiveSymbol(REGULAR_SYMBOL(lhs));

	createTreeIfNotExistent(lhs);

	m_trees[lhs]->setNewNodes(true);
	return m_trees[lhs]->addRootChild(encoded);
}

Tree* Forest::operator[](const Symbol lhs) {
	return m_trees[lhs];
}

set<Symbol> Forest::getRootLabels() {
	set<Symbol> labels;
	map<Symbol,Tree*>::iterator it = m_trees.begin();
	while ( it != m_trees.end() ) {
		labels.insert((*it).first);
		it++;
	}
	return labels;
}

set<Tree*> Forest::getTrees() {
	set<Tree*> trees;
	map<Symbol,Tree*>::iterator it = m_trees.begin();
	while ( it != m_trees.end() ) {
		trees.insert((*it).second);
		it++;
	}
	return trees;
}


void Forest::resetFollowedMarkers() {
	map<Symbol,Tree*>::iterator it = m_trees.begin();
	while ( it != m_trees.end() ) {
		Tree* tree = (*it).second;
		tree->setFollowed(false);
		it++;
	}
}

void Forest::resetNewMarkers() {
	map<Symbol,Tree*>::iterator it = m_trees.begin();
	while ( it != m_trees.end() ) {
		Tree* tree = (*it).second;
		tree->setNewNodes(false);
		it++;
	}
}


string Forest::decodeNode2String(TreeNode* node) {
	return m_grammar.getProductionString(node->getProduction());
}

string Forest::getEncodingTableString() {
	return m_grammar.getEncodingTableString();
}

string Forest::getProductionsString(set<Production> productions, bool compact) {
	return m_grammar.getProductionsString(productions, compact);
}

void Forest::createTreeIfNotExistent(Symbol lhs) {
	if ( m_trees.find(lhs) != m_trees.end() )
		return;
	Production rootProduction(lhs, vector<Symbol>());
	m_trees[lhs] = new Tree(new TreeNode(rootProduction));
}

} /* namespace IGNF */
